/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Date;
import java.util.HashSet;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.CalendarFunctions;

public class RemoveOldCalendarStatements
implements GtfsTransformStrategy {
    @CsvField(optional=true)
    private boolean removeToday = false;
    @CsvField(ignore=true)
    private CalendarFunctions helper = new CalendarFunctions();

    public void setRemoveToday(boolean removeToday) {
        this.removeToday = removeToday;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashSet<ServiceCalendar> serviceCalendarsToRemove = new HashSet<ServiceCalendar>();
        Date today = new Date();
        if (!this.removeToday) {
            today = this.helper.removeTime(today);
        }
        for (ServiceCalendar calendar : gtfsMutableRelationalDao.getAllCalendars()) {
            if (!calendar.getEndDate().getAsDate().before(today)) continue;
            serviceCalendarsToRemove.add(calendar);
        }
        for (ServiceCalendar serviceCalendar : serviceCalendarsToRemove) {
            removeEntityLibrary.removeCalendar(gtfsMutableRelationalDao, serviceCalendar.getServiceId());
        }
        HashSet<ServiceCalendarDate> serviceCalendarDatesToRemove = new HashSet<ServiceCalendarDate>();
        for (ServiceCalendarDate calendarDate : gtfsMutableRelationalDao.getAllCalendarDates()) {
            if (!calendarDate.getDate().getAsDate().before(today)) continue;
            serviceCalendarDatesToRemove.add(calendarDate);
        }
        for (ServiceCalendarDate serviceCalendarDate : serviceCalendarDatesToRemove) {
            removeEntityLibrary.removeServiceCalendarDate(gtfsMutableRelationalDao, serviceCalendarDate);
        }
    }
}

