/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStopIdFromReferenceStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateStopIdFromReferenceStrategy.class);
    private static final int LOCATION_NAME_INDEX = 0;
    private static final int DIRECTION = 3;
    private static final int ATIS_ID_INDEX = 6;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        ArrayList<AgencyAndId> stopsAdded = new ArrayList<AgencyAndId>();
        ArrayList<Stop> stopsToAdd = new ArrayList<Stop>();
        HashMap<String, Stop> referenceStops = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            referenceStops.put(stop.getId().getId(), stop);
        }
        AgencyAndId agencyAndId = ((Stop)dao.getAllStops().iterator().next()).getId();
        for (Stop stop : dao.getAllStops()) {
            Stop existingStop;
            String parentStation = stop.getParentStation();
            if (parentStation == null || (existingStop = dao.getStopForId(new AgencyAndId(agencyAndId.getAgencyId(), parentStation))) != null || stopsAdded.contains(((Stop)referenceStops.get(parentStation)).getId())) continue;
            Stop stopToAdd = new Stop();
            stopToAdd.setId(((Stop)referenceStops.get(parentStation)).getId());
            stopToAdd.setName(((Stop)referenceStops.get(parentStation)).getName());
            stopToAdd.setLat(((Stop)referenceStops.get(parentStation)).getLat());
            stopToAdd.setLon(((Stop)referenceStops.get(parentStation)).getLon());
            stopToAdd.setLocationType(((Stop)referenceStops.get(parentStation)).getLocationType());
            stopsAdded.add(((Stop)referenceStops.get(parentStation)).getId());
            stopsToAdd.add(stopToAdd);
        }
        for (Stop stop : stopsToAdd) {
            dao.saveOrUpdateEntity((Object)stop);
            this._log.info("updating stops {}", (Object)stop.getId());
        }
    }
}

