/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddExtensionFile
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(AddExtensionFile.class);
    @CsvField(optional=false)
    private String extensionFilename;
    @CsvField(optional=false)
    private String extensionName;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public void setExtensionFilename(String extensionFilename) {
        this.extensionFilename = extensionFilename;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        if (this.extensionFilename == null) {
            throw new IllegalStateException("missing required param extensionFilename");
        }
        if (this.extensionName == null) {
            throw new IllegalStateException("missing required param extensionName");
        }
        _log.info("AddExtensionFile entered with {} to {}", (Object)this.extensionName, (Object)this.extensionFilename);
        File extension = new File(this.extensionFilename);
        if (!extension.exists()) {
            throw new IllegalStateException("attempt to add non-existant extension file:" + extension.getName());
        }
        String content = null;
        try {
            content = Files.readString(extension.toPath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (content == null) {
            throw new IllegalStateException("no content for specified file " + this.extensionFilename);
        }
        _log.info("AddExtensionFile copying {} to {}", (Object)this.extensionName, (Object)this.extensionFilename);
        dao.addMetadata(this.extensionName, content);
    }
}

