/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class ShapeDirectionTransformStrategy
implements GtfsTransformStrategy {
    @CsvField
    String shapeId;
    @CsvField
    String shapeDirection;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        ArrayList<Trip> tripsToTransform = new ArrayList<Trip>();
        Collection allTrips = dao.getAllTrips();
        for (Trip t : allTrips) {
            if (!t.getShapeId().getId().equals(this.shapeId) || t.getDirectionId().equals(this.shapeDirection)) continue;
            tripsToTransform.add(t);
        }
        if (!tripsToTransform.isEmpty()) {
            String agencyId = context.getDefaultAgencyId();
            AgencyAndId inputShapeId = new AgencyAndId(agencyId, this.shapeId);
            AgencyAndId newShapeId = new AgencyAndId(agencyId, this.shapeId + "R");
            ArrayList shapePoints = new ArrayList(dao.getShapePointsForShapeId(inputShapeId));
            Collections.reverse(shapePoints);
            int newIndex = 1;
            for (ShapePoint sp : shapePoints) {
                ShapePoint nsp = new ShapePoint();
                nsp.setShapeId(newShapeId);
                nsp.setSequence(newIndex++);
                nsp.setLat(sp.getLat());
                nsp.setLon(sp.getLon());
                dao.saveEntity((Object)nsp);
            }
            for (Trip t : tripsToTransform) {
                t.setShapeId(newShapeId);
            }
        }
    }

    public void setShapeDirection(String shapeDirection) {
        this.shapeDirection = shapeDirection;
    }

    public void setShapeId(String shapeId) {
        this.shapeId = shapeId;
    }
}

