/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.CsvTokenizerStrategy;
import org.onebusaway.gtfs.csv.EntityHandler;
import org.onebusaway.gtfs.csv.TokenizerStrategy;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.csv.schema.EntitySchema;
import org.onebusaway.gtfs.csv.schema.FieldMapping;

class IndividualCsvEntityWriter
implements EntityHandler {
    private PrintWriter _writer;
    private List<String> _fieldNames = new ArrayList<String>();
    private EntitySchema _schema;
    private CsvEntityContext _context;
    private TokenizerStrategy _tokenizerStrategy = new CsvTokenizerStrategy();
    private boolean _seenFirstRecord = false;

    public IndividualCsvEntityWriter(CsvEntityContext context, EntitySchema schema, PrintWriter writer) {
        this._writer = writer;
        this._schema = schema;
        this._context = context;
    }

    public void setTokenizerStrategy(TokenizerStrategy tokenizerStrategy) {
        this._tokenizerStrategy = tokenizerStrategy;
    }

    @Override
    public void handleEntity(Object object) {
        if (!this._seenFirstRecord) {
            this._fieldNames.clear();
            for (FieldMapping field : this._schema.getFields()) {
                field.getCSVFieldNames(this._fieldNames);
            }
            this._writer.println(this._tokenizerStrategy.format(this._fieldNames));
            this._seenFirstRecord = true;
        }
        BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
        HashMap<String, Object> csvValues = new HashMap<String, Object>();
        for (FieldMapping field : this._schema.getFields()) {
            field.translateFromObjectToCSV(this._context, wrapper, csvValues);
        }
        ArrayList<String> values = new ArrayList<String>(csvValues.size());
        for (String fieldName : this._fieldNames) {
            Object value = csvValues.get(fieldName);
            if (value == null) {
                value = "";
            }
            values.add(value.toString());
        }
        String line = this._tokenizerStrategy.format(values);
        this._writer.println(line);
    }

    public void flush() {
        this._writer.flush();
    }

    public void close() {
        this._writer.close();
    }
}

