/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Collection;
import java.util.Map;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.DefaultFieldMapping;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.FieldMapping;
import org.onebusaway.gtfs.csv.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;

public class AgencyIdFieldMappingFactory
implements FieldMappingFactory {
    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, String.class, required);
    }

    private class FieldMappingImpl
    extends DefaultFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, objFieldType, required);
        }

        @Override
        public void getCSVFieldNames(Collection<String> names) {
            names.add(this._csvFieldName + "_agencyId");
            names.add(this._csvFieldName + "_id");
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            AgencyAndId id = (AgencyAndId)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName + "_agencyId", id.getAgencyId());
            csvValues.put(this._csvFieldName + "_id", id.getId());
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            String agencyId = (String)csvValues.get(this._csvFieldName + "_agencyId");
            String id = (String)csvValues.get(this._csvFieldName + "_id");
            AgencyAndId agencyAndId = new AgencyAndId(agencyId, id);
            object.setPropertyValue(this._objFieldName, agencyAndId);
        }
    }
}

