/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.onebusaway.gtfs.csv.schema.AbstractEntitySchemaFactoryImpl;
import org.onebusaway.gtfs.csv.schema.ListableCsvMappingFactory;
import org.onebusaway.gtfs.csv.schema.beans.CsvEntityMappingBean;

public class DefaultEntitySchemaFactory
extends AbstractEntitySchemaFactoryImpl {
    private List<BeanDefinitionSource> _sources = new ArrayList<BeanDefinitionSource>();

    public void addBean(CsvEntityMappingBean bean) {
        this._sources.add(new CsvEntityMappingBeanSource(bean));
    }

    public void addFactory(ListableCsvMappingFactory factory) {
        this._sources.add(new ListableCsvMappingFactorySource(factory));
    }

    @Override
    protected void processBeanDefinitions() {
        for (BeanDefinitionSource source : this._sources) {
            source.processBeanDefinitions();
        }
    }

    private class ListableCsvMappingFactorySource
    implements BeanDefinitionSource {
        private ListableCsvMappingFactory _factory;

        public ListableCsvMappingFactorySource(ListableCsvMappingFactory factory) {
            this._factory = factory;
        }

        @Override
        public void processBeanDefinitions() {
            Collection<CsvEntityMappingBean> beans = this._factory.getEntityMappings();
            for (CsvEntityMappingBean bean : beans) {
                DefaultEntitySchemaFactory.this.registerBeanDefinition(bean);
            }
        }
    }

    private class CsvEntityMappingBeanSource
    implements BeanDefinitionSource {
        private CsvEntityMappingBean _bean;

        public CsvEntityMappingBeanSource(CsvEntityMappingBean bean) {
            this._bean = bean;
        }

        @Override
        public void processBeanDefinitions() {
            DefaultEntitySchemaFactory.this.registerBeanDefinition(this._bean);
        }
    }

    private static interface BeanDefinitionSource {
        public void processBeanDefinitions();
    }
}

