/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.calendar.UnknownAgencyTimezoneException;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarServiceDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceDataFactoryImpl
implements CalendarServiceDataFactory {
    private final Logger _log = LoggerFactory.getLogger(CalendarServiceDataFactoryImpl.class);
    private GtfsRelationalDao _dao;
    private int _excludeFutureServiceDatesInDays;

    public CalendarServiceDataFactoryImpl() {
    }

    public CalendarServiceDataFactoryImpl(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    public void setGtfsDao(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    public void setExcludeFutureServiceDatesInDays(int excludeFutureServiceDatesInDays) {
        this._excludeFutureServiceDatesInDays = excludeFutureServiceDatesInDays;
    }

    @Override
    public CalendarServiceData createData() {
        CalendarServiceData data = new CalendarServiceData();
        this.setTimeZonesForAgencies(data);
        Collection<ServiceCalendar> calendars = this._dao.getAllCalendars();
        Collection<ServiceCalendarDate> calendarDates = this._dao.getAllCalendarDates();
        Map<AgencyAndId, ServiceCalendar> calendarsByServiceId = this.getCalendarsByServiceId(calendars);
        Map<AgencyAndId, List<ServiceCalendarDate>> calendarDatesByServiceId = this.getCalendarDatesByServiceId(calendarDates);
        HashSet<AgencyAndId> serviceIds = new HashSet<AgencyAndId>();
        serviceIds.addAll(calendarsByServiceId.keySet());
        serviceIds.addAll(calendarDatesByServiceId.keySet());
        int index = 0;
        for (AgencyAndId serviceId : serviceIds) {
            this._log.info("serviceId=" + serviceId + " (" + ++index + "/" + serviceIds.size() + ")");
            HashSet<ServiceDate> activeDates = new HashSet<ServiceDate>();
            ServiceCalendar c = calendarsByServiceId.get(serviceId);
            if (c != null) {
                this.addDatesFromCalendar(c, activeDates);
            }
            if (calendarDatesByServiceId.containsKey(serviceId)) {
                for (ServiceCalendarDate cd : calendarDatesByServiceId.get(serviceId)) {
                    this.addAndRemoveDatesFromCalendarDate(cd, activeDates);
                }
            }
            ArrayList<ServiceDate> serviceDates = new ArrayList<ServiceDate>(activeDates);
            Collections.sort(serviceDates);
            data.putServiceDatesForServiceId(serviceId, serviceDates);
            List<String> tripAgencyIds = this._dao.getTripAgencyIdsReferencingServiceId(serviceId);
            HashSet<TimeZone> timeZones = new HashSet<TimeZone>();
            for (String tripAgencyId : tripAgencyIds) {
                TimeZone timeZone = data.getTimeZoneForAgencyId(tripAgencyId);
                timeZones.add(timeZone);
            }
            for (TimeZone timeZone : timeZones) {
                ArrayList<Date> dates = new ArrayList<Date>(serviceDates.size());
                for (ServiceDate serviceDate : serviceDates) {
                    dates.add(serviceDate.getAsDate(timeZone));
                }
                LocalizedServiceId id = new LocalizedServiceId(serviceId, timeZone);
                data.putDatesForLocalizedServiceId(id, dates);
            }
        }
        return data;
    }

    private void setTimeZonesForAgencies(CalendarServiceData data) {
        for (Agency agency : this._dao.getAllAgencies()) {
            TimeZone timeZone = TimeZone.getTimeZone(agency.getTimezone());
            if (timeZone == null) {
                throw new UnknownAgencyTimezoneException(agency.getName(), agency.getTimezone());
            }
            data.putTimeZoneForAgencyId(agency.getId(), timeZone);
        }
    }

    private Map<AgencyAndId, ServiceCalendar> getCalendarsByServiceId(Collection<ServiceCalendar> calendars) {
        HashMap<AgencyAndId, ServiceCalendar> calendarsByServiceId = new HashMap<AgencyAndId, ServiceCalendar>();
        for (ServiceCalendar c : calendars) {
            calendarsByServiceId.put(c.getServiceId(), c);
        }
        return calendarsByServiceId;
    }

    private Map<AgencyAndId, List<ServiceCalendarDate>> getCalendarDatesByServiceId(Collection<ServiceCalendarDate> calendarDates) {
        HashMap<AgencyAndId, List<ServiceCalendarDate>> calendarDatesByServiceId = new HashMap<AgencyAndId, List<ServiceCalendarDate>>();
        for (ServiceCalendarDate calendarDate : calendarDates) {
            ArrayList<ServiceCalendarDate> cds = (ArrayList<ServiceCalendarDate>)calendarDatesByServiceId.get(calendarDate.getServiceId());
            if (cds == null) {
                cds = new ArrayList<ServiceCalendarDate>();
                calendarDatesByServiceId.put(calendarDate.getServiceId(), cds);
            }
            cds.add(calendarDate);
        }
        return calendarDatesByServiceId;
    }

    private void addDatesFromCalendar(ServiceCalendar calendar, Set<ServiceDate> activeDates) {
        Date date;
        Date startDate = calendar.getStartDate().getAsDate();
        Date endDate = calendar.getEndDate().getAsDate();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        while (!(date = c.getTime()).after(endDate)) {
            int day = c.get(7);
            boolean active = false;
            switch (day) {
                case 2: {
                    active = calendar.getMonday() == 1;
                    break;
                }
                case 3: {
                    active = calendar.getTuesday() == 1;
                    break;
                }
                case 4: {
                    active = calendar.getWednesday() == 1;
                    break;
                }
                case 5: {
                    active = calendar.getThursday() == 1;
                    break;
                }
                case 6: {
                    active = calendar.getFriday() == 1;
                    break;
                }
                case 7: {
                    active = calendar.getSaturday() == 1;
                    break;
                }
                case 1: {
                    boolean bl = active = calendar.getSunday() == 1;
                }
            }
            if (active) {
                this.addServiceDate(activeDates, c);
            }
            c.add(6, 1);
        }
    }

    private void addAndRemoveDatesFromCalendarDate(ServiceCalendarDate calendarDate, Set<ServiceDate> activeDates) {
        Date targetDate = calendarDate.getDate().getAsDate();
        Calendar c = Calendar.getInstance();
        c.setTime(targetDate);
        switch (calendarDate.getExceptionType()) {
            case 1: {
                this.addServiceDate(activeDates, c);
                break;
            }
            case 2: {
                activeDates.remove(new ServiceDate(c));
                break;
            }
            default: {
                this._log.warn("unknown CalendarDate exception type: " + calendarDate.getExceptionType());
            }
        }
    }

    private void addServiceDate(Set<ServiceDate> activeDates, Calendar c) {
        int days;
        if (this._excludeFutureServiceDatesInDays > 0 && (days = (int)((c.getTimeInMillis() - System.currentTimeMillis()) / 86400000L)) > this._excludeFutureServiceDatesInDays) {
            return;
        }
        activeDates.add(new ServiceDate(c));
    }
}

