/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.CsvEntityContextImpl;
import org.onebusaway.gtfs.csv.EntityHandler;
import org.onebusaway.gtfs.csv.IndividualCsvEntityWriter;
import org.onebusaway.gtfs.csv.exceptions.CsvEntityIOException;
import org.onebusaway.gtfs.csv.schema.DefaultEntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.EntitySchema;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;

public class CsvEntityWriter
implements EntityHandler {
    private File _outputLocation;
    private EntitySchemaFactory _entitySchemaFactory = new DefaultEntitySchemaFactory();
    private CsvEntityContext _context = new CsvEntityContextImpl();
    private Map<Class<?>, IndividualCsvEntityWriter> _writersByType = new HashMap();

    public EntitySchemaFactory getEntitySchemaFactory() {
        return this._entitySchemaFactory;
    }

    public void setEntitySchemaFactory(EntitySchemaFactory entitySchemaFactory) {
        this._entitySchemaFactory = entitySchemaFactory;
    }

    public void setOutputLocation(File path) {
        this._outputLocation = path;
    }

    @Override
    public void handleEntity(Object entity) {
        Class<?> entityType = entity.getClass();
        IndividualCsvEntityWriter writer = this.getEntityWriter(entityType);
        writer.handleEntity(entity);
    }

    public void flush() {
        for (IndividualCsvEntityWriter writer : this._writersByType.values()) {
            writer.flush();
        }
    }

    public void close() {
        for (IndividualCsvEntityWriter writer : this._writersByType.values()) {
            writer.close();
        }
    }

    private IndividualCsvEntityWriter getEntityWriter(Class<?> entityType) {
        IndividualCsvEntityWriter entityWriter = this._writersByType.get(entityType);
        if (entityWriter == null) {
            EntitySchema schema = this._entitySchemaFactory.getSchema(entityType);
            File outputFile = new File(this._outputLocation, schema.getFilename());
            if (!this._outputLocation.exists()) {
                this._outputLocation.mkdirs();
            }
            PrintWriter writer = this.openOutput(outputFile, entityType);
            entityWriter = new IndividualCsvEntityWriter(this._context, schema, writer);
            this._writersByType.put(entityType, entityWriter);
        }
        return entityWriter;
    }

    private PrintWriter openOutput(File outputFile, Class<?> entityType) {
        try {
            return new PrintWriter(outputFile, "UTF-8");
        }
        catch (IOException ex) {
            throw new CsvEntityIOException(entityType, outputFile.getAbsolutePath(), 0, ex);
        }
    }
}

