/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv;

import java.io.PrintWriter;
import java.io.Writer;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.CsvEntityContextImpl;
import org.onebusaway.gtfs.csv.CsvTokenizerStrategy;
import org.onebusaway.gtfs.csv.EntityHandler;
import org.onebusaway.gtfs.csv.IndividualCsvEntityWriter;
import org.onebusaway.gtfs.csv.TokenizerStrategy;
import org.onebusaway.gtfs.csv.schema.DefaultEntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.EntitySchema;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;

public class CsvEntityWriterFactory {
    private EntitySchemaFactory _entitySchemaFactory = new DefaultEntitySchemaFactory();
    private CsvEntityContext _context = new CsvEntityContextImpl();
    private TokenizerStrategy _tokenizerStrategy = new CsvTokenizerStrategy();

    public EntitySchemaFactory getEntitySchemaFactory() {
        return this._entitySchemaFactory;
    }

    public void setEntitySchemaFactory(EntitySchemaFactory entitySchemaFactory) {
        this._entitySchemaFactory = entitySchemaFactory;
    }

    public CsvEntityContext getContext() {
        return this._context;
    }

    public void setContext(CsvEntityContext context) {
        this._context = context;
    }

    public void setTokenizerStrategy(TokenizerStrategy tokenizerStrategy) {
        this._tokenizerStrategy = tokenizerStrategy;
    }

    public EntityHandler createWriter(Class<?> entityType, Writer writer) {
        EntitySchema schema = this._entitySchemaFactory.getSchema(entityType);
        IndividualCsvEntityWriter entityWriter = new IndividualCsvEntityWriter(this._context, schema, new PrintWriter(writer));
        if (this._tokenizerStrategy != null) {
            entityWriter.setTokenizerStrategy(this._tokenizerStrategy);
        }
        return entityWriter;
    }
}

