/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.onebusaway.gtfs.csv.CsvInputSource;

public class ZipFileCsvInputSource
implements CsvInputSource {
    private ZipFile _zipFile;

    public ZipFileCsvInputSource(ZipFile zipFile) {
        this._zipFile = zipFile;
    }

    @Override
    public boolean hasResource(String name) throws IOException {
        ZipEntry entry = this._zipFile.getEntry(name);
        return entry != null;
    }

    @Override
    public InputStream getResource(String name) throws IOException {
        ZipEntry entry = this._zipFile.getEntry(name);
        return this._zipFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this._zipFile.close();
    }
}

