/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv.schema;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.csv.exceptions.EntityInstantiationException;
import org.onebusaway.gtfs.csv.schema.DefaultFieldMapping;
import org.onebusaway.gtfs.csv.schema.EntitySchema;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.EntityValidator;
import org.onebusaway.gtfs.csv.schema.FieldMapping;
import org.onebusaway.gtfs.csv.schema.FieldMappingFactory;
import org.onebusaway.gtfs.csv.schema.ListableCsvMappingFactory;
import org.onebusaway.gtfs.csv.schema.annotations.CsvField;
import org.onebusaway.gtfs.csv.schema.annotations.CsvFields;
import org.onebusaway.gtfs.csv.schema.beans.CsvEntityMappingBean;
import org.onebusaway.gtfs.csv.schema.beans.CsvFieldMappingBean;

public abstract class AbstractEntitySchemaFactoryImpl
implements EntitySchemaFactory,
ListableCsvMappingFactory {
    private boolean _initialized = false;
    private Map<Class<?>, CsvEntityMappingBean> _mappingBeansByClass = new HashMap();
    private Map<Class<?>, EntitySchema> _schemasByClass = new HashMap();

    @Override
    public Collection<CsvEntityMappingBean> getEntityMappings() {
        this.initialize();
        return new ArrayList<CsvEntityMappingBean>(this._mappingBeansByClass.values());
    }

    @Override
    public EntitySchema getSchema(Class<?> entityClass) {
        this.initialize();
        EntitySchema schema = this._schemasByClass.get(entityClass);
        if (schema == null) {
            schema = this.createSchemaForEntityClass(entityClass);
            this._schemasByClass.put(entityClass, schema);
        }
        return schema;
    }

    protected abstract void processBeanDefinitions();

    protected void registerBeanDefinition(CsvEntityMappingBean bean) {
        CsvEntityMappingBean existingBean = this._mappingBeansByClass.get(bean.getType());
        if (existingBean != null) {
            CsvEntityMappingBean merged = new CsvEntityMappingBean(bean.getType());
            this.mergeBeans(existingBean, merged);
            this.mergeBeans(bean, merged);
            bean = merged;
        }
        this._mappingBeansByClass.put(bean.getType(), bean);
    }

    protected void applyCsvFieldsAnnotationToBean(Class<?> entityClass, CsvEntityMappingBean entityBean) {
        CsvFields csvFields = entityClass.getAnnotation(CsvFields.class);
        if (csvFields != null) {
            String[] fieldsInOrder;
            entityBean.setFilename(csvFields.filename());
            if (!csvFields.prefix().equals("")) {
                entityBean.setPrefix(csvFields.prefix());
            }
            if (csvFields.required()) {
                entityBean.setRequired(csvFields.required());
            }
            if ((fieldsInOrder = csvFields.fieldOrder()).length != 0) {
                for (String fieldInOrder : fieldsInOrder) {
                    entityBean.addFieldInOrder(fieldInOrder);
                }
            }
        }
    }

    protected void applyCsvFieldAnnotationToBean(Field field, CsvFieldMappingBean fieldBean) {
        CsvField csvField = field.getAnnotation(CsvField.class);
        if (csvField != null) {
            Class<? extends FieldMappingFactory> mapping;
            if (!csvField.name().equals("")) {
                fieldBean.setName(csvField.name());
            }
            if (csvField.ignore()) {
                fieldBean.setIgnore(csvField.ignore());
            }
            if (csvField.optional()) {
                fieldBean.setOptional(csvField.optional());
            }
            if (csvField.order() != 0) {
                fieldBean.setOrder(csvField.order());
            }
            if (!(mapping = csvField.mapping()).equals(FieldMappingFactory.class)) {
                try {
                    FieldMappingFactory factory = mapping.newInstance();
                    fieldBean.setMapping(factory);
                }
                catch (Exception ex) {
                    throw new EntityInstantiationException(mapping, (Throwable)ex);
                }
            }
        }
    }

    private void initialize() {
        if (!this._initialized) {
            this.processBeanDefinitions();
            this._initialized = true;
        }
    }

    private void mergeBeans(CsvEntityMappingBean source, CsvEntityMappingBean target) {
        List<String> fieldsInOrder;
        if (source.isFilenameSet()) {
            target.setFilename(source.getFilename());
        }
        if (source.isPrefixSet()) {
            target.setPrefix(source.getPrefix());
        }
        if (source.isRequiredSet()) {
            target.setRequired(source.isRequired());
        }
        if (source.isAutoGenerateSchemaSet()) {
            target.setAutoGenerateSchema(source.isAutoGenerateSchema());
        }
        if (!(fieldsInOrder = source.getFieldsInOrder()).isEmpty()) {
            target.setFieldsInOrder(fieldsInOrder);
        }
        for (FieldMapping mapping : source.getAdditionalFieldMappings()) {
            target.addAdditionalFieldMapping(mapping);
        }
        Map<Field, CsvFieldMappingBean> sourceFields = source.getFields();
        Map<Field, CsvFieldMappingBean> targetFields = target.getFields();
        for (Map.Entry<Field, CsvFieldMappingBean> entry : sourceFields.entrySet()) {
            Field sourceField = entry.getKey();
            CsvFieldMappingBean sourceFieldBean = entry.getValue();
            CsvFieldMappingBean targetFieldBean = targetFields.get(sourceField);
            if (targetFieldBean == null) {
                targetFieldBean = sourceFieldBean;
            } else {
                this.mergeFields(sourceFieldBean, targetFieldBean);
            }
            targetFields.put(sourceField, targetFieldBean);
        }
    }

    private void mergeFields(CsvFieldMappingBean source, CsvFieldMappingBean target) {
        if (source.isNameSet()) {
            target.setName(source.getName());
        }
        if (source.isIgnoreSet()) {
            target.setIgnore(target.isIgnore());
        }
        if (source.isMappingSet()) {
            target.setMapping(source.getMapping());
        }
        if (source.isOptionalSet()) {
            target.setOptional(source.isOptional());
        }
        if (source.isOrderSet()) {
            target.setOrder(source.getOrder());
        }
    }

    private EntitySchema createSchemaForEntityClass(Class<?> entityClass) {
        CsvEntityMappingBean mappingBean = this._mappingBeansByClass.get(entityClass);
        if (mappingBean == null) {
            mappingBean = new CsvEntityMappingBean(entityClass);
            this.applyCsvFieldsAnnotationToBean(entityClass, mappingBean);
        }
        String name = this.getEntityClassAsEntityName(entityClass);
        if (mappingBean.isFilenameSet()) {
            name = mappingBean.getFilename();
        }
        String prefix = "";
        if (mappingBean.isPrefixSet()) {
            prefix = mappingBean.getPrefix();
        }
        boolean required = false;
        if (mappingBean.isRequiredSet()) {
            required = mappingBean.isRequired();
        }
        boolean autoGenerateSchema = true;
        if (mappingBean.isAutoGenerateSchemaSet()) {
            autoGenerateSchema = mappingBean.isAutoGenerateSchema();
        }
        EntitySchema schema = new EntitySchema(entityClass, name, required);
        Map<Field, CsvFieldMappingBean> existingFieldBeans = mappingBean.getFields();
        ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();
        if (autoGenerateSchema) {
            for (Field field : entityClass.getDeclaredFields()) {
                CsvFieldMappingBean fieldMappingBean = existingFieldBeans.get(field);
                if (fieldMappingBean == null) {
                    boolean ignore;
                    fieldMappingBean = new CsvFieldMappingBean(field);
                    this.applyCsvFieldAnnotationToBean(field, fieldMappingBean);
                    boolean bl = ignore = (field.getModifiers() & 0x18) != 0;
                    if (ignore) {
                        fieldMappingBean.setIgnore(ignore);
                    }
                }
                if (fieldMappingBean.isIgnoreSet() && fieldMappingBean.isIgnore()) continue;
                FieldMapping mapping = this.getFieldMapping(entityClass, field, fieldMappingBean, prefix);
                fieldMappings.add(mapping);
            }
        }
        for (FieldMapping fieldMapping : mappingBean.getAdditionalFieldMappings()) {
            fieldMappings.add(fieldMapping);
        }
        Collections.sort(fieldMappings, new FieldMappingComparator());
        for (FieldMapping mapping : fieldMappings) {
            schema.addField(mapping);
        }
        ArrayList<EntityValidator> validators = new ArrayList<EntityValidator>();
        validators.addAll(mappingBean.getValidators());
        Collections.sort(validators, new ValidatorComparator());
        for (EntityValidator validator : validators) {
            schema.addValidator(validator);
        }
        List<String> fieldsInOrder = mappingBean.getFieldsInOrder();
        if (!fieldsInOrder.isEmpty()) {
            schema.setFieldsInOrder(fieldsInOrder);
        }
        return schema;
    }

    private FieldMapping getFieldMapping(Class<?> entityClass, Field field, CsvFieldMappingBean fieldMappingBean, String prefix) {
        FieldMapping mapping = null;
        String objFieldName = field.getName();
        Class<?> objFieldType = field.getType();
        String csvFieldName = prefix + this.getObjectFieldNameAsCSVFieldName(objFieldName);
        boolean required = true;
        if (fieldMappingBean.isOptionalSet()) {
            boolean bl = required = !fieldMappingBean.isOptional();
        }
        if (fieldMappingBean.isNameSet()) {
            csvFieldName = fieldMappingBean.getName();
        }
        if (fieldMappingBean.isMappingSet()) {
            FieldMappingFactory factory = fieldMappingBean.getMapping();
            mapping = factory.createFieldMapping(this, entityClass, csvFieldName, objFieldName, objFieldType, required);
        }
        if (mapping == null) {
            DefaultFieldMapping m = new DefaultFieldMapping(entityClass, csvFieldName, objFieldName, objFieldType, required);
            try {
                String name = field.getName();
                String isFieldSet = "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "Set";
                Method method = entityClass.getMethod(isFieldSet, new Class[0]);
                if (method != null && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                    m.setIsSetMethod(method);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            mapping = m;
        }
        if (fieldMappingBean.isOrderSet()) {
            mapping.setOrder(fieldMappingBean.getOrder());
        }
        return mapping;
    }

    private String getEntityClassAsEntityName(Class<?> entityClass) {
        String name = entityClass.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private String getObjectFieldNameAsCSVFieldName(String fieldName) {
        StringBuilder b = new StringBuilder();
        boolean wasUpperCase = false;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase) {
                c = Character.toLowerCase(c);
            }
            if (isUpperCase && !wasUpperCase) {
                b.append('_');
            }
            b.append(c);
            wasUpperCase = isUpperCase;
        }
        return b.toString();
    }

    private static class ValidatorComparator
    implements Comparator<EntityValidator> {
        private ValidatorComparator() {
        }

        @Override
        public int compare(EntityValidator o1, EntityValidator o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }

    private static class FieldMappingComparator
    implements Comparator<FieldMapping> {
        private FieldMappingComparator() {
        }

        @Override
        public int compare(FieldMapping o1, FieldMapping o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }
}

