/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv.schema;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.onebusaway.gtfs.csv.exceptions.MethodInvocationException;
import org.onebusaway.gtfs.csv.exceptions.MissingRequiredFieldException;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.FieldMapping;

public abstract class AbstractFieldMapping
implements FieldMapping {
    protected final Class<?> _entityType;
    protected final String _csvFieldName;
    protected final String _objFieldName;
    protected final boolean _required;
    protected int _order = 0;
    protected Method _isSetMethod = null;

    public AbstractFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
        this._entityType = entityType;
        this._csvFieldName = csvFieldName;
        this._objFieldName = objFieldName;
        this._required = required;
    }

    @Override
    public void setOrder(int order) {
        this._order = order;
    }

    public void setIsSetMethod(Method isSetMethod) {
        this._isSetMethod = isSetMethod;
    }

    @Override
    public void getCSVFieldNames(Collection<String> names) {
        names.add(this._csvFieldName);
    }

    @Override
    public int getOrder() {
        return this._order;
    }

    protected boolean isMissing(Map<String, Object> csvValues) {
        return !csvValues.containsKey(this._csvFieldName) || csvValues.get(this._csvFieldName).toString().length() <= 0;
    }

    protected boolean isMissing(BeanWrapper object) {
        block4: {
            if (this._isSetMethod != null) {
                Object instance = object.getWrappedInstance(Object.class);
                try {
                    Object r = this._isSetMethod.invoke(instance, new Object[0]);
                    if (r != null && r instanceof Boolean) {
                        Boolean b = (Boolean)r;
                        return b == false;
                    }
                    break block4;
                }
                catch (Exception ex) {
                    throw new MethodInvocationException(this._entityType, this._isSetMethod, ex);
                }
            }
            Object obj = object.getPropertyValue(this._objFieldName);
            return obj == null;
        }
        return false;
    }

    protected boolean isMissingAndOptional(Map<String, Object> csvValues) {
        boolean missing = this.isMissing(csvValues);
        if (this._required && missing) {
            throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
        }
        return missing;
    }

    protected boolean isMissingAndOptional(BeanWrapper object) {
        boolean missing = this.isMissing(object);
        if (this._required && missing) {
            throw new MissingRequiredFieldException(this._entityType, this._objFieldName);
        }
        return missing;
    }

    protected boolean isOptional() {
        return !this._required;
    }
}

