/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.schema.AbstractFieldMapping;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.FieldMapping;
import org.onebusaway.gtfs.csv.schema.FieldMappingFactory;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class AgencyIdTranslationFieldMappingFactory
implements FieldMappingFactory {
    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, String.class, required);
    }

    private class FieldMappingImpl
    extends AbstractFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            csvValues.put(this._csvFieldName, object.getPropertyValue(this._objFieldName));
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            String agencyId = (String)csvValues.get(this._csvFieldName);
            GtfsReaderContext ctx = (GtfsReaderContext)context.get(GtfsReader.KEY_CONTEXT);
            agencyId = ctx.getTranslatedAgencyId(agencyId);
            object.setPropertyValue(this._objFieldName, agencyId);
        }
    }
}

