/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv.schema;

import java.util.Collection;
import java.util.Map;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.exceptions.EntityInstantiationException;
import org.onebusaway.gtfs.csv.schema.AbstractFieldMapping;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.csv.schema.EntitySchema;
import org.onebusaway.gtfs.csv.schema.FieldMapping;

class FlattenFieldMapping
extends AbstractFieldMapping {
    private Class<?> _objFieldType;
    private EntitySchema _schema;

    public FlattenFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required, EntitySchema schema) {
        super(entityType, csvFieldName, objFieldName, required);
        this._objFieldType = objFieldType;
        this._schema = schema;
    }

    @Override
    public void getCSVFieldNames(Collection<String> names) {
        for (FieldMapping mapping : this._schema.getFields()) {
            mapping.getCSVFieldNames(names);
        }
    }

    @Override
    public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
        Object id = this.getInstance(this._objFieldType);
        BeanWrapper wrapper = BeanWrapperFactory.wrap(id);
        for (FieldMapping mapping : this._schema.getFields()) {
            mapping.translateFromCSVToObject(context, csvValues, wrapper);
        }
        object.setPropertyValue(this._objFieldName, id);
    }

    @Override
    public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
        Object id = object.getPropertyValue(this._objFieldName);
        BeanWrapper wrapper = BeanWrapperFactory.wrap(id);
        for (FieldMapping mapping : this._schema.getFields()) {
            mapping.translateFromObjectToCSV(context, wrapper, csvValues);
        }
    }

    private Object getInstance(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            throw new EntityInstantiationException(type, (Throwable)ex);
        }
    }
}

