/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;

public class CalendarServiceData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, TimeZone> _timeZonesByAgencyId = new HashMap<String, TimeZone>();
    private Map<AgencyAndId, List<ServiceDate>> _serviceDatesByServiceId = new HashMap<AgencyAndId, List<ServiceDate>>();
    private Map<LocalizedServiceId, List<Date>> _datesByLocalizedServiceId = new HashMap<LocalizedServiceId, List<Date>>();
    private Map<ServiceDate, Set<AgencyAndId>> _serviceIdsByDate = new HashMap<ServiceDate, Set<AgencyAndId>>();

    public TimeZone getTimeZoneForAgencyId(String agencyId) {
        return this._timeZonesByAgencyId.get(agencyId);
    }

    public void putTimeZoneForAgencyId(String agencyId, TimeZone timeZone) {
        this._timeZonesByAgencyId.put(agencyId, timeZone);
    }

    public Set<AgencyAndId> getServiceIds() {
        return Collections.unmodifiableSet(this._serviceDatesByServiceId.keySet());
    }

    public List<ServiceDate> getServiceDatesForServiceId(AgencyAndId serviceId) {
        return this._serviceDatesByServiceId.get(serviceId);
    }

    public Set<AgencyAndId> getServiceIdsForDate(ServiceDate date) {
        Set<AgencyAndId> serviceIds = this._serviceIdsByDate.get(date);
        if (serviceIds == null) {
            serviceIds = new HashSet<AgencyAndId>();
        }
        return serviceIds;
    }

    public void putServiceDatesForServiceId(AgencyAndId serviceId, List<ServiceDate> serviceDates) {
        Collections.sort(serviceDates);
        this._serviceDatesByServiceId.put(serviceId, serviceDates);
        for (ServiceDate serviceDate : serviceDates) {
            Set<AgencyAndId> serviceIds = this._serviceIdsByDate.get(serviceDate);
            if (serviceIds == null) {
                serviceIds = new HashSet<AgencyAndId>();
                this._serviceIdsByDate.put(serviceDate, serviceIds);
            }
            serviceIds.add(serviceId);
        }
    }

    public List<Date> getDatesForLocalizedServiceId(LocalizedServiceId serviceId) {
        return this._datesByLocalizedServiceId.get(serviceId);
    }

    public void putDatesForLocalizedServiceId(LocalizedServiceId serviceId, List<Date> dates) {
        this._datesByLocalizedServiceId.put(serviceId, dates);
    }
}

