/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.csv.CSVListener;

public class CSVLibrary {
    public static String escapeValue(String value) {
        if (value.indexOf(44) != -1 || value.indexOf(34) != -1) {
            value = "\"" + value.replaceAll("\"", "\"\"") + "\"";
        }
        return value;
    }

    public static String getArrayAsCSV(double[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (double v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = false;
            }
            csv.append(v);
        }
        return csv.toString();
    }

    public static <T> String getArrayAsCSV(T[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static <T> String getIterableAsCSV(Iterable<T> args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static String getAsCSV(Object ... args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (Object v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static final void parse(InputStream is, CSVListener handler) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        CSVLibrary.parse(reader, handler);
    }

    public static final void parse(File input, CSVListener handler) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(input));
        CSVLibrary.parse(r, handler);
    }

    public static void parse(BufferedReader r, CSVListener handler) throws IOException, Exception {
        String line = null;
        int lineNumber = 1;
        while ((line = r.readLine()) != null) {
            List<String> values = CSVLibrary.parse(line);
            try {
                handler.handleLine(values);
            }
            catch (Exception ex) {
                throw new Exception("error handling csv record for lineNumber=" + lineNumber, ex);
            }
            ++lineNumber;
        }
        r.close();
    }

    public static final List<String> parse(String line) {
        StringBuilder token = new StringBuilder();
        ArrayList<StringBuilder> tokens = new ArrayList<StringBuilder>();
        if (line.length() > 0) {
            tokens.add(token);
        }
        EParseState state = EParseState.DATA;
        block16: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (state) {
                case DATA: {
                    switch (c) {
                        case '\"': {
                            if (token.length() == 0) {
                                state = EParseState.DATA_IN_QUOTES;
                                continue block16;
                            }
                            token.append(c);
                            continue block16;
                        }
                        case ',': {
                            token = new StringBuilder();
                            tokens.add(token);
                            continue block16;
                        }
                    }
                    token.append(c);
                    continue block16;
                }
                case DATA_IN_QUOTES: {
                    switch (c) {
                        case '\"': {
                            state = EParseState.END_QUOTE;
                            continue block16;
                        }
                    }
                    token.append(c);
                    continue block16;
                }
                case END_QUOTE: {
                    switch (c) {
                        case '\"': {
                            token.append('\"');
                            state = EParseState.DATA_IN_QUOTES;
                            continue block16;
                        }
                        case ',': {
                            token = new StringBuilder();
                            tokens.add(token);
                            state = EParseState.DATA;
                            continue block16;
                        }
                    }
                    token.append(c);
                    state = EParseState.DATA;
                }
            }
        }
        ArrayList<String> retro = new ArrayList<String>(tokens.size());
        for (StringBuilder b : tokens) {
            retro.add(b.toString());
        }
        return retro;
    }

    private static enum EParseState {
        DATA,
        DATA_IN_QUOTES,
        END_QUOTE;

    }
}

