/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class EntityFieldMappingFactory
implements FieldMappingFactory {
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, objFieldType, required);
    }

    public static class FieldMappingImpl
    extends AbstractFieldMapping {
        private Class<?> _objFieldType;

        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
            this._objFieldType = objFieldType;
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            String entityId = (String)csvValues.get(this._csvFieldName);
            String agencyId = ctx.getAgencyForEntity(this._objFieldType, entityId);
            AgencyAndId id = new AgencyAndId(agencyId, entityId);
            Object entity = ctx.getEntity(this._objFieldType, id);
            object.setPropertyValue(this._objFieldName, entity);
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            IdentityBean entity = (IdentityBean)object.getPropertyValue(this._objFieldName);
            if (this.isOptional() && entity == null) {
                return;
            }
            AgencyAndId id = (AgencyAndId)entity.getId();
            csvValues.put(this._csvFieldName, id.getId());
        }
    }
}

