/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceDate
implements Serializable,
Comparable<ServiceDate> {
    private static final long serialVersionUID = 1L;
    private static final Pattern _pattern = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})$");
    private static final NumberFormat _yearFormat = new DecimalFormat("0000");
    private static final NumberFormat _monthAndDayFormat = new DecimalFormat("00");
    private final int year;
    private final int month;
    private final int day;

    public ServiceDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public ServiceDate(ServiceDate o) {
        this(o.year, o.month, o.day);
    }

    public ServiceDate(Calendar calendar) {
        this(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public ServiceDate(Date date) {
        this(ServiceDate.getCalendarForDate(date));
    }

    public ServiceDate() {
        this(new Date());
    }

    public static ServiceDate parseString(String value) {
        Matcher matcher = _pattern.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalStateException("error parsing date: " + value);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        return new ServiceDate(year, month, day);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date getAsDate() {
        return this.getAsDate(TimeZone.getDefault());
    }

    public Calendar getAsCalendar(TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.day);
        ServiceDate.moveCalendarToServiceDate(c);
        return c;
    }

    public Date getAsDate(TimeZone timeZone) {
        Calendar c = this.getAsCalendar(timeZone);
        return c.getTime();
    }

    public String getAsString() {
        String year = _yearFormat.format(this.year);
        String month = _monthAndDayFormat.format(this.month);
        String day = _monthAndDayFormat.format(this.day);
        return year + month + day;
    }

    public ServiceDate next(TimeZone timeZone) {
        Calendar c = this.getAsCalendar(timeZone);
        c.add(6, 1);
        return new ServiceDate(c);
    }

    public ServiceDate previous(TimeZone timeZone) {
        Calendar c = this.getAsCalendar(timeZone);
        c.add(6, -11);
        return new ServiceDate(c);
    }

    @Override
    public int compareTo(ServiceDate o) {
        int c = this.year - o.year;
        if (c == 0) {
            c = this.month - o.month;
        }
        if (c == 0) {
            c = this.day - o.day;
        }
        return c;
    }

    public String toString() {
        return "ServiceIdDate(" + this.year + "-" + this.month + "-" + this.day + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDate other = (ServiceDate)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    public static void moveCalendarToServiceDate(Calendar c) {
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(11, -12);
    }

    private static final Calendar getCalendarForDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }
}

