/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.exceptions.EntityInstantiationException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.impl.GtfsDaoImpl;
import org.onebusaway.gtfs.impl.MultipleCalendarsForServiceIdException;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;

public class GtfsRelationalDaoImpl
extends GtfsDaoImpl
implements GtfsMutableRelationalDao {
    private Map<AgencyAndId, List<String>> _tripAgencyIdsByServiceId = null;
    private Map<Agency, List<Route>> _routesByAgency = null;
    private Map<Stop, List<Stop>> _stopsByStation = null;
    private Map<Trip, List<StopTime>> _stopTimesByTrip = null;
    private Map<Stop, List<StopTime>> _stopTimesByStop = null;
    private Map<Route, List<Trip>> _tripsByRoute = null;
    private Map<AgencyAndId, List<Trip>> _tripsByBlockId = null;
    private Map<AgencyAndId, List<ShapePoint>> _shapePointsByShapeId = null;
    private Map<Trip, List<Frequency>> _frequenciesByTrip = null;
    private Map<AgencyAndId, List<ServiceCalendarDate>> _calendarDatesByServiceId = null;
    private Map<AgencyAndId, List<ServiceCalendar>> _calendarsByServiceId = null;

    public void clearAllCaches() {
        this._tripAgencyIdsByServiceId = this.clearMap(this._tripAgencyIdsByServiceId);
        this._routesByAgency = this.clearMap(this._routesByAgency);
        this._stopsByStation = this.clearMap(this._stopsByStation);
        this._stopTimesByTrip = this.clearMap(this._stopTimesByTrip);
        this._stopTimesByStop = this.clearMap(this._stopTimesByStop);
        this._tripsByRoute = this.clearMap(this._tripsByRoute);
        this._tripsByBlockId = this.clearMap(this._tripsByBlockId);
        this._shapePointsByShapeId = this.clearMap(this._shapePointsByShapeId);
        this._frequenciesByTrip = this.clearMap(this._frequenciesByTrip);
        this._calendarDatesByServiceId = this.clearMap(this._calendarDatesByServiceId);
        this._calendarsByServiceId = this.clearMap(this._calendarsByServiceId);
    }

    @Override
    public List<String> getTripAgencyIdsReferencingServiceId(AgencyAndId serviceId) {
        List<String> agencyIds;
        if (this._tripAgencyIdsByServiceId == null) {
            HashMap<AgencyAndId, HashSet<String>> agencyIdsByServiceIds = new HashMap<AgencyAndId, HashSet<String>>();
            for (Trip trip : this.getAllTrips()) {
                AgencyAndId tripId = trip.getId();
                String tripAgencyId = tripId.getAgencyId();
                AgencyAndId tripServiceId = trip.getServiceId();
                HashSet<String> agencyIds2 = (HashSet<String>)agencyIdsByServiceIds.get(tripServiceId);
                if (agencyIds2 == null) {
                    agencyIds2 = new HashSet<String>();
                    agencyIdsByServiceIds.put(tripServiceId, agencyIds2);
                }
                agencyIds2.add(tripAgencyId);
            }
            this._tripAgencyIdsByServiceId = new HashMap<AgencyAndId, List<String>>();
            for (Map.Entry entry : agencyIdsByServiceIds.entrySet()) {
                AgencyAndId tripServiceId = (AgencyAndId)entry.getKey();
                ArrayList agencyIds3 = new ArrayList((Collection)entry.getValue());
                Collections.sort(agencyIds3);
                this._tripAgencyIdsByServiceId.put(tripServiceId, agencyIds3);
            }
        }
        if ((agencyIds = this._tripAgencyIdsByServiceId.get(serviceId)) == null) {
            agencyIds = new ArrayList<String>();
        }
        return agencyIds;
    }

    @Override
    public List<Route> getRoutesForAgency(Agency agency) {
        if (this._routesByAgency == null) {
            this._routesByAgency = GtfsRelationalDaoImpl.mapToValueList(this.getAllRoutes(), "agency", Agency.class);
        }
        return GtfsRelationalDaoImpl.list(this._routesByAgency.get(agency));
    }

    @Override
    public List<Stop> getStopsForStation(Stop station) {
        if (this._stopsByStation == null) {
            this._stopsByStation = new HashMap<Stop, List<Stop>>();
            for (Stop stop : this.getAllStops()) {
                if (stop.getLocationType() != 0 || stop.getParentStation() == null) continue;
                Stop parentStation = this.getStopForId(new AgencyAndId(stop.getId().getAgencyId(), stop.getParentStation()));
                List<Stop> subStops = this._stopsByStation.get(parentStation);
                if (subStops == null) {
                    subStops = new ArrayList<Stop>(2);
                    this._stopsByStation.put(parentStation, subStops);
                }
                subStops.add(stop);
            }
        }
        return GtfsRelationalDaoImpl.list(this._stopsByStation.get(station));
    }

    @Override
    public List<AgencyAndId> getAllShapeIds() {
        this.ensureShapePointRelation();
        return new ArrayList<AgencyAndId>(this._shapePointsByShapeId.keySet());
    }

    @Override
    public List<ShapePoint> getShapePointsForShapeId(AgencyAndId shapeId) {
        this.ensureShapePointRelation();
        return GtfsRelationalDaoImpl.list(this._shapePointsByShapeId.get(shapeId));
    }

    @Override
    public List<StopTime> getStopTimesForTrip(Trip trip) {
        if (this._stopTimesByTrip == null) {
            this._stopTimesByTrip = GtfsRelationalDaoImpl.mapToValueList(this.getAllStopTimes(), "trip", Trip.class);
            for (List<StopTime> stopTimes : this._stopTimesByTrip.values()) {
                Collections.sort(stopTimes);
            }
        }
        return GtfsRelationalDaoImpl.list(this._stopTimesByTrip.get(trip));
    }

    @Override
    public List<StopTime> getStopTimesForStop(Stop stop) {
        if (this._stopTimesByStop == null) {
            this._stopTimesByStop = GtfsRelationalDaoImpl.mapToValueList(this.getAllStopTimes(), "stop", Stop.class);
        }
        return GtfsRelationalDaoImpl.list(this._stopTimesByStop.get(stop));
    }

    @Override
    public List<Trip> getTripsForRoute(Route route) {
        if (this._tripsByRoute == null) {
            this._tripsByRoute = GtfsRelationalDaoImpl.mapToValueList(this.getAllTrips(), "route", Route.class);
        }
        return GtfsRelationalDaoImpl.list(this._tripsByRoute.get(route));
    }

    @Override
    public List<Trip> getTripsForBlockId(AgencyAndId blockId) {
        if (this._tripsByBlockId == null) {
            this._tripsByBlockId = new HashMap<AgencyAndId, List<Trip>>();
            for (Trip trip : this.getAllTrips()) {
                if (trip.getBlockId() == null) continue;
                AgencyAndId bid = new AgencyAndId(trip.getId().getAgencyId(), trip.getBlockId());
                List<Trip> trips = this._tripsByBlockId.get(bid);
                if (trips == null) {
                    trips = new ArrayList<Trip>();
                    this._tripsByBlockId.put(bid, trips);
                }
                trips.add(trip);
            }
        }
        return GtfsRelationalDaoImpl.list(this._tripsByBlockId.get(blockId));
    }

    @Override
    public List<Frequency> getFrequenciesForTrip(Trip trip) {
        if (this._frequenciesByTrip == null) {
            this._frequenciesByTrip = GtfsRelationalDaoImpl.mapToValueList(this.getAllFrequencies(), "trip", Trip.class);
        }
        return GtfsRelationalDaoImpl.list(this._frequenciesByTrip.get(trip));
    }

    @Override
    public List<ServiceCalendarDate> getCalendarDatesForServiceId(AgencyAndId serviceId) {
        if (this._calendarDatesByServiceId == null) {
            this._calendarDatesByServiceId = GtfsRelationalDaoImpl.mapToValueList(this.getAllCalendarDates(), "serviceId", AgencyAndId.class);
        }
        return GtfsRelationalDaoImpl.list(this._calendarDatesByServiceId.get(serviceId));
    }

    @Override
    public ServiceCalendar getCalendarForServiceId(AgencyAndId serviceId) {
        if (this._calendarsByServiceId == null) {
            this._calendarsByServiceId = GtfsRelationalDaoImpl.mapToValueList(this.getAllCalendars(), "serviceId", AgencyAndId.class);
        }
        List<ServiceCalendar> calendars = GtfsRelationalDaoImpl.list(this._calendarsByServiceId.get(serviceId));
        switch (calendars.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return calendars.get(0);
            }
        }
        throw new MultipleCalendarsForServiceIdException(serviceId);
    }

    private void ensureShapePointRelation() {
        if (this._shapePointsByShapeId == null) {
            this._shapePointsByShapeId = GtfsRelationalDaoImpl.mapToValueList(this.getAllShapePoints(), "shapeId", AgencyAndId.class);
            for (List<ShapePoint> shapePoints : this._shapePointsByShapeId.values()) {
                Collections.sort(shapePoints);
            }
        }
    }

    private static <T> List<T> list(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, List<V>> mapToValueList(Iterable<V> values, String property, Class<K> keyType) {
        return GtfsRelationalDaoImpl.mapToValueCollection(values, property, keyType, new ArrayList().getClass());
    }

    private static <K, V, C extends Collection<V>, CIMPL extends C> Map<K, C> mapToValueCollection(Iterable<V> values, String property, Class<K> keyType, Class<CIMPL> collectionType) {
        HashMap<Object, Collection> byKey = new HashMap<Object, Collection>();
        SimplePropertyQuery query = new SimplePropertyQuery(property);
        for (V value : values) {
            Object key = query.invoke(value);
            Collection valuesForKey = (Collection)byKey.get(key);
            if (valuesForKey == null) {
                try {
                    valuesForKey = (Collection)collectionType.newInstance();
                }
                catch (Exception ex) {
                    throw new EntityInstantiationException(collectionType, (Throwable)ex);
                }
                byKey.put(key, valuesForKey);
            }
            valuesForKey.add(value);
        }
        return byKey;
    }

    private <K, V> Map<K, V> clearMap(Map<K, V> map) {
        if (map != null) {
            map.clear();
        }
        return null;
    }

    private static final class SimplePropertyQuery {
        private String[] _properties;

        public SimplePropertyQuery(String query) {
            this._properties = query.split("\\.");
        }

        public Object invoke(Object value) {
            for (String property : this._properties) {
                BeanWrapper wrapper = BeanWrapperFactory.wrap((Object)value);
                value = wrapper.getPropertyValue(property);
            }
            return value;
        }
    }
}

