/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactoryHelper;
import org.onebusaway.csv_entities.schema.EntityValidator;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.csv_entities.schema.beans.CsvEntityMappingBean;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.comparators.ServiceCalendarComparator;
import org.onebusaway.gtfs.serialization.comparators.ServiceCalendarDateComparator;
import org.onebusaway.gtfs.serialization.comparators.ShapePointComparator;
import org.onebusaway.gtfs.serialization.comparators.StopTimeComparator;
import org.onebusaway.gtfs.serialization.mappings.AgencyIdTranslationFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.RouteAgencyFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.RouteValidator;
import org.onebusaway.gtfs.serialization.mappings.ServiceDateFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;

public class GtfsEntitySchemaFactory {
    public static List<Class<?>> getEntityClasses() {
        ArrayList entityClasses = new ArrayList();
        entityClasses.add(Agency.class);
        entityClasses.add(ShapePoint.class);
        entityClasses.add(Route.class);
        entityClasses.add(Stop.class);
        entityClasses.add(Trip.class);
        entityClasses.add(StopTime.class);
        entityClasses.add(ServiceCalendar.class);
        entityClasses.add(ServiceCalendarDate.class);
        entityClasses.add(FareAttribute.class);
        entityClasses.add(FareRule.class);
        entityClasses.add(Frequency.class);
        entityClasses.add(Pathway.class);
        entityClasses.add(Transfer.class);
        return entityClasses;
    }

    public static Map<Class<?>, Comparator<?>> getEntityComparators() {
        HashMap comparators = new HashMap();
        comparators.put(Agency.class, GtfsEntitySchemaFactory.getComparatorForIdentityBeanType(Agency.class));
        comparators.put(Route.class, GtfsEntitySchemaFactory.getComparatorForIdentityBeanType(Route.class));
        comparators.put(Stop.class, GtfsEntitySchemaFactory.getComparatorForIdentityBeanType(Stop.class));
        comparators.put(Trip.class, GtfsEntitySchemaFactory.getComparatorForIdentityBeanType(Trip.class));
        comparators.put(StopTime.class, new StopTimeComparator());
        comparators.put(ShapePoint.class, new ShapePointComparator());
        comparators.put(ServiceCalendar.class, new ServiceCalendarComparator());
        comparators.put(ServiceCalendarDate.class, new ServiceCalendarDateComparator());
        return comparators;
    }

    public static DefaultEntitySchemaFactory createEntitySchemaFactory() {
        DefaultEntitySchemaFactory factory = new DefaultEntitySchemaFactory();
        EntitySchemaFactoryHelper helper = new EntitySchemaFactoryHelper(factory);
        CsvEntityMappingBean agencyId = helper.addEntity(AgencyAndId.class);
        helper.addIgnorableField(agencyId, "agencyId");
        CsvEntityMappingBean agency = helper.addEntity(Agency.class, "agency.txt", "agency_");
        helper.addOptionalField(agency, "id", "agency_id", (FieldMappingFactory)new AgencyIdTranslationFieldMappingFactory());
        helper.addOptionalFields(agency, new String[]{"lang", "phone"});
        helper.addOptionalField(agency, "fareUrl", "agency_fare_url");
        CsvEntityMappingBean route = helper.addEntity(Route.class, "routes.txt", "route_");
        helper.addOptionalField(route, "agency", "agency_id", (FieldMappingFactory)new RouteAgencyFieldMappingFactory());
        helper.addField(route, "id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory("agency.id"), 1);
        helper.addOptionalFields(route, new String[]{"desc", "shortName", "longName", "url", "color", "textColor", "bikesAllowed"});
        route.addValidator((EntityValidator)new RouteValidator());
        CsvEntityMappingBean shapePoint = helper.addEntity(ShapePoint.class, "shapes.txt");
        shapePoint.setRequired(false);
        helper.addIgnorableField(shapePoint, "id");
        helper.addOptionalField(shapePoint, "shapeId", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addOptionalField(shapePoint, "distTraveled", "shape_dist_traveled");
        helper.addField(shapePoint, "lat", "shape_pt_lat");
        helper.addField(shapePoint, "lon", "shape_pt_lon");
        helper.addField(shapePoint, "sequence", "shape_pt_sequence");
        CsvEntityMappingBean stop = helper.addEntity(Stop.class, "stops.txt", "stop_");
        helper.addField(stop, "id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addOptionalFields(stop, new String[]{"code", "desc", "direction", "url"});
        helper.addOptionalField(stop, "zoneId", "zone_id");
        helper.addOptionalField(stop, "locationType", "location_type");
        helper.addOptionalField(stop, "parentStation", "parent_station");
        helper.addOptionalField(stop, "wheelchairBoarding", "wheelchair_boarding");
        CsvEntityMappingBean trip = helper.addEntity(Trip.class, "trips.txt");
        helper.addField(trip, "route", "route_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(trip, "id", "trip_id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory("route.agency.id"), 1);
        helper.addOptionalFields(trip, new String[]{"tripShortName", "tripHeadsign", "routeShortName", "directionId", "blockId"});
        helper.addField(trip, "serviceId", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addOptionalField(trip, "shapeId", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addOptionalField(trip, "wheelchairAccessible", "wheelchair_accessible");
        helper.addOptionalField(trip, "tripBikesAllowed");
        CsvEntityMappingBean stopTime = helper.addEntity(StopTime.class, "stop_times.txt");
        helper.addIgnorableField(stopTime, "id");
        helper.addField(stopTime, "trip", "trip_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(stopTime, "stop", "stop_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addOptionalField(stopTime, "arrivalTime", (FieldMappingFactory)new StopTimeFieldMappingFactory());
        helper.addOptionalField(stopTime, "departureTime", (FieldMappingFactory)new StopTimeFieldMappingFactory());
        helper.addOptionalFields(stopTime, new String[]{"stopHeadsign", "routeShortName", "pickupType", "dropOffType", "shapeDistTraveled"});
        CsvEntityMappingBean calendar = helper.addEntity(ServiceCalendar.class, "calendar.txt");
        helper.addIgnorableField(calendar, "id");
        helper.addField(calendar, "serviceId", "service_id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addField(calendar, "startDate", (FieldMappingFactory)new ServiceDateFieldMappingFactory());
        helper.addField(calendar, "endDate", (FieldMappingFactory)new ServiceDateFieldMappingFactory());
        CsvEntityMappingBean calendarDate = helper.addEntity(ServiceCalendarDate.class, "calendar_dates.txt");
        calendarDate.setRequired(false);
        helper.addIgnorableField(calendarDate, "id");
        helper.addField(calendarDate, "serviceId", "service_id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addField(calendarDate, "date", (FieldMappingFactory)new ServiceDateFieldMappingFactory());
        CsvEntityMappingBean fareAttributes = helper.addEntity(FareAttribute.class, "fare_attributes.txt");
        fareAttributes.setRequired(false);
        helper.addField(fareAttributes, "id", "fare_id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addFields(fareAttributes, new String[]{"price", "currencyType", "paymentMethod"});
        helper.addOptionalFields(fareAttributes, new String[]{"transfers", "transferDuration", "journeyDuration"});
        CsvEntityMappingBean fareRules = helper.addEntity(FareRule.class, "fare_rules.txt");
        fareRules.setRequired(false);
        helper.addIgnorableField(fareRules, "id");
        helper.addField(fareRules, "fare", "fare_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addOptionalField(fareRules, "route", "route_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addOptionalFields(fareRules, new String[]{"originId", "destinationId", "containsId"});
        CsvEntityMappingBean frequencies = helper.addEntity(Frequency.class, "frequencies.txt");
        frequencies.setRequired(false);
        helper.addIgnorableField(frequencies, "id");
        helper.addField(frequencies, "trip", "trip_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addOptionalField(frequencies, "startTime", (FieldMappingFactory)new StopTimeFieldMappingFactory());
        helper.addOptionalField(frequencies, "endTime", (FieldMappingFactory)new StopTimeFieldMappingFactory());
        helper.addFields(frequencies, new String[]{"headwaySecs"});
        helper.addOptionalField(frequencies, "exactTimes");
        CsvEntityMappingBean pathways = helper.addEntity(Pathway.class, "pathways.txt");
        pathways.setRequired(false);
        helper.addField(pathways, "id", "pathway_id", (FieldMappingFactory)new DefaultAgencyIdFieldMappingFactory());
        helper.addField(pathways, "fromStop", "from_stop_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(pathways, "toStop", "to_stop_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(pathways, "traversalTime", "traversal_time");
        helper.addOptionalField(pathways, "wheelchairTraversalTime", "wheelchair_traversal_time");
        CsvEntityMappingBean transfers = helper.addEntity(Transfer.class, "transfers.txt");
        transfers.setRequired(false);
        helper.addIgnorableField(transfers, "id");
        helper.addField(transfers, "fromStop", "from_stop_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(transfers, "toStop", "to_stop_id", (FieldMappingFactory)new EntityFieldMappingFactory());
        helper.addField(transfers, "transferType");
        helper.addOptionalField(transfers, "minTransferTime");
        CsvEntityMappingBean feedInfo = helper.addEntity(FeedInfo.class, "feed_info.txt");
        feedInfo.setRequired(false);
        helper.addIgnorableField(feedInfo, "id");
        helper.addField(feedInfo, "publisherName", "feed_publisher_name");
        helper.addField(feedInfo, "publisherUrl", "feed_publisher_url");
        helper.addField(feedInfo, "lang", "feed_lang");
        helper.addOptionalField(feedInfo, "startDate", "feed_start_date", (FieldMappingFactory)new ServiceDateFieldMappingFactory());
        helper.addOptionalField(feedInfo, "endDate", "feed_end_date", (FieldMappingFactory)new ServiceDateFieldMappingFactory());
        helper.addOptionalField(feedInfo, "version", "feed_version");
        return factory;
    }

    private static <T extends IdentityBean<?>> Comparator<T> getComparatorForIdentityBeanType(Class<T> entityType) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable a = (Comparable)((IdentityBean)o1).getId();
                Comparable b = (Comparable)((IdentityBean)o2).getId();
                return a.compareTo(b);
            }
        };
    }
}

