/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.InvalidStopTimeException;

public class StopTimeFieldMappingFactory
implements FieldMappingFactory {
    private static DecimalFormat _format = new DecimalFormat("00");
    private static Pattern _pattern = Pattern.compile("^(\\d{1,2}):(\\d{2}):(\\d{2})$");

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new StopTimeFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    public static String getSecondsAsString(int t) {
        int hours = t / 3600;
        int minutes = (t -= hours * 3600) / 60;
        int seconds = t -= minutes * 60;
        String value = _format.format(hours) + ":" + _format.format(minutes) + ":" + _format.format(seconds);
        return value;
    }

    private static class StopTimeFieldMapping
    extends AbstractFieldMapping {
        public StopTimeFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            String stringValue = value.toString();
            Matcher m = _pattern.matcher(stringValue);
            if (!m.matches()) {
                throw new InvalidStopTimeException(stringValue);
            }
            try {
                int hours = Integer.parseInt(m.group(1));
                int minutes = Integer.parseInt(m.group(2));
                int seconds = Integer.parseInt(m.group(3));
                object.setPropertyValue(this._objFieldName, (Object)(seconds + 60 * (minutes + 60 * hours)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidStopTimeException(stringValue);
            }
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            int t = (Integer)object.getPropertyValue(this._objFieldName);
            if (t < 0) {
                csvValues.put(this._csvFieldName, "");
                return;
            }
            String value = StopTimeFieldMappingFactory.getSecondsAsString(t);
            csvValues.put(this._csvFieldName, value);
        }
    }
}

