/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;

@CsvFields(filename="stop_times.txt")
public final class StopTime
extends IdentityBean<Integer>
implements Comparable<StopTime> {
    private static final long serialVersionUID = 1L;
    private static final int MISSING_VALUE = -999;
    @CsvField(ignore=true)
    private int id;
    @CsvField(name="trip_id", mapping=EntityFieldMappingFactory.class)
    private Trip trip;
    @CsvField(name="stop_id", mapping=EntityFieldMappingFactory.class)
    private Stop stop;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int arrivalTime = -999;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int departureTime = -999;
    private int stopSequence;
    @CsvField(optional=true)
    private String stopHeadsign;
    @CsvField(optional=true)
    private String routeShortName;
    @CsvField(optional=true, defaultValue="0")
    private int pickupType;
    @CsvField(optional=true, defaultValue="0")
    private int dropOffType;
    @CsvField(optional=true)
    private double shapeDistTraveled = -999.0;

    public StopTime() {
    }

    public StopTime(StopTime st) {
        this.arrivalTime = st.arrivalTime;
        this.departureTime = st.departureTime;
        this.dropOffType = st.dropOffType;
        this.id = st.id;
        this.pickupType = st.pickupType;
        this.routeShortName = st.routeShortName;
        this.shapeDistTraveled = st.shapeDistTraveled;
        this.stop = st.stop;
        this.stopHeadsign = st.stopHeadsign;
        this.stopSequence = st.stopSequence;
        this.trip = st.trip;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public void setTrip(Trip trip) {
        this.trip = trip;
    }

    public int getStopSequence() {
        return this.stopSequence;
    }

    public void setStopSequence(int stopSequence) {
        this.stopSequence = stopSequence;
    }

    public Stop getStop() {
        return this.stop;
    }

    public void setStop(Stop stop) {
        this.stop = stop;
    }

    public boolean isArrivalTimeSet() {
        return this.arrivalTime != -999;
    }

    public int getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(int arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public void clearArrivalTime() {
        this.arrivalTime = -999;
    }

    public boolean isDepartureTimeSet() {
        return this.departureTime != -999;
    }

    public int getDepartureTime() {
        return this.departureTime;
    }

    public void setDepartureTime(int departureTime) {
        this.departureTime = departureTime;
    }

    public void clearDepartureTime() {
        this.departureTime = -999;
    }

    public String getStopHeadsign() {
        return this.stopHeadsign;
    }

    public void setStopHeadsign(String headSign) {
        this.stopHeadsign = headSign;
    }

    public String getRouteShortName() {
        return this.routeShortName;
    }

    public void setRouteShortName(String routeShortName) {
        this.routeShortName = routeShortName;
    }

    public int getPickupType() {
        return this.pickupType;
    }

    public void setPickupType(int pickupType) {
        this.pickupType = pickupType;
    }

    public int getDropOffType() {
        return this.dropOffType;
    }

    public void setDropOffType(int dropOffType) {
        this.dropOffType = dropOffType;
    }

    public boolean isShapeDistTraveledSet() {
        return this.shapeDistTraveled != -999.0;
    }

    public double getShapeDistTraveled() {
        return this.shapeDistTraveled;
    }

    public void setShapeDistTraveled(double shapeDistTraveled) {
        this.shapeDistTraveled = shapeDistTraveled;
    }

    public void clearShapeDistTraveled() {
        this.shapeDistTraveled = -999.0;
    }

    @Override
    public int compareTo(StopTime o) {
        return this.stopSequence - o.stopSequence;
    }

    public String toString() {
        return "StopTime(seq=" + this.stopSequence + " stop=" + this.stop.getId() + " trip=" + this.trip.getId() + " times=" + StopTimeFieldMappingFactory.getSecondsAsString(this.arrivalTime) + "-" + StopTimeFieldMappingFactory.getSecondsAsString(this.departureTime) + ")";
    }
}

