/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceImpl;
import org.onebusaway.gtfs.impl.calendar.UnknownAgencyTimezoneException;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs.services.calendar.CalendarServiceDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceDataFactoryImpl
implements CalendarServiceDataFactory {
    private final Logger _log = LoggerFactory.getLogger(CalendarServiceDataFactoryImpl.class);
    private GtfsRelationalDao _dao;
    private int _excludeFutureServiceDatesInDays;

    public static CalendarService createService(GtfsRelationalDao dao) {
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl(dao);
        return new CalendarServiceImpl(factory.createData());
    }

    public CalendarServiceDataFactoryImpl() {
    }

    public CalendarServiceDataFactoryImpl(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    public void setGtfsDao(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    public void setExcludeFutureServiceDatesInDays(int excludeFutureServiceDatesInDays) {
        this._excludeFutureServiceDatesInDays = excludeFutureServiceDatesInDays;
    }

    @Override
    public CalendarServiceData createData() {
        CalendarServiceData data = new CalendarServiceData();
        this.setTimeZonesForAgencies(data);
        List<AgencyAndId> serviceIds = this._dao.getAllServiceIds();
        int index = 0;
        for (AgencyAndId serviceId : serviceIds) {
            this._log.info("serviceId=" + serviceId + " (" + ++index + "/" + serviceIds.size() + ")");
            TimeZone serviceIdTimeZone = data.getTimeZoneForAgencyId(serviceId.getAgencyId());
            if (serviceIdTimeZone == null) {
                serviceIdTimeZone = TimeZone.getDefault();
            }
            Set<ServiceDate> activeDates = this.getServiceDatesForServiceId(serviceId, serviceIdTimeZone);
            ArrayList<ServiceDate> serviceDates = new ArrayList<ServiceDate>(activeDates);
            Collections.sort(serviceDates);
            data.putServiceDatesForServiceId(serviceId, serviceDates);
            List<String> tripAgencyIds = this._dao.getTripAgencyIdsReferencingServiceId(serviceId);
            HashSet<TimeZone> timeZones = new HashSet<TimeZone>();
            for (String tripAgencyId : tripAgencyIds) {
                TimeZone timeZone = data.getTimeZoneForAgencyId(tripAgencyId);
                timeZones.add(timeZone);
            }
            for (TimeZone timeZone : timeZones) {
                ArrayList<Date> dates = new ArrayList<Date>(serviceDates.size());
                for (ServiceDate serviceDate : serviceDates) {
                    dates.add(serviceDate.getAsDate(timeZone));
                }
                LocalizedServiceId id = new LocalizedServiceId(serviceId, timeZone);
                data.putDatesForLocalizedServiceId(id, dates);
            }
        }
        return data;
    }

    public Set<ServiceDate> getServiceDatesForServiceId(AgencyAndId serviceId, TimeZone serviceIdTimeZone) {
        HashSet<ServiceDate> activeDates = new HashSet<ServiceDate>();
        ServiceCalendar c = this._dao.getCalendarForServiceId(serviceId);
        if (c != null) {
            this.addDatesFromCalendar(c, serviceIdTimeZone, activeDates);
        }
        for (ServiceCalendarDate cd : this._dao.getCalendarDatesForServiceId(serviceId)) {
            this.addAndRemoveDatesFromCalendarDate(cd, serviceIdTimeZone, activeDates);
        }
        return activeDates;
    }

    private void setTimeZonesForAgencies(CalendarServiceData data) {
        for (Agency agency : this._dao.getAllAgencies()) {
            TimeZone timeZone = TimeZone.getTimeZone(agency.getTimezone());
            if (timeZone.getID().equals("GMT") && !agency.getTimezone().toUpperCase().equals("gmt")) {
                throw new UnknownAgencyTimezoneException(agency.getName(), agency.getTimezone());
            }
            data.putTimeZoneForAgencyId(agency.getId(), timeZone);
        }
    }

    private void addDatesFromCalendar(ServiceCalendar calendar, TimeZone timeZone, Set<ServiceDate> activeDates) {
        Date date;
        Date startDate = CalendarServiceDataFactoryImpl.getServiceDateAsNoon(calendar.getStartDate(), timeZone);
        Date endDate = CalendarServiceDataFactoryImpl.getServiceDateAsNoon(calendar.getEndDate(), timeZone);
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(startDate);
        while (!(date = c.getTime()).after(endDate)) {
            int day = c.get(7);
            boolean active = false;
            switch (day) {
                case 2: {
                    active = calendar.getMonday() == 1;
                    break;
                }
                case 3: {
                    active = calendar.getTuesday() == 1;
                    break;
                }
                case 4: {
                    active = calendar.getWednesday() == 1;
                    break;
                }
                case 5: {
                    active = calendar.getThursday() == 1;
                    break;
                }
                case 6: {
                    active = calendar.getFriday() == 1;
                    break;
                }
                case 7: {
                    active = calendar.getSaturday() == 1;
                    break;
                }
                case 1: {
                    boolean bl = active = calendar.getSunday() == 1;
                }
            }
            if (active) {
                this.addServiceDate(activeDates, new ServiceDate(c), timeZone);
            }
            c.add(6, 1);
        }
    }

    private void addAndRemoveDatesFromCalendarDate(ServiceCalendarDate calendarDate, TimeZone serviceIdTimeZone, Set<ServiceDate> activeDates) {
        ServiceDate serviceDate = calendarDate.getDate();
        Date targetDate = calendarDate.getDate().getAsDate();
        Calendar c = Calendar.getInstance();
        c.setTime(targetDate);
        switch (calendarDate.getExceptionType()) {
            case 1: {
                this.addServiceDate(activeDates, serviceDate, serviceIdTimeZone);
                break;
            }
            case 2: {
                activeDates.remove(serviceDate);
                break;
            }
            default: {
                this._log.warn("unknown CalendarDate exception type: " + calendarDate.getExceptionType());
            }
        }
    }

    private void addServiceDate(Set<ServiceDate> activeDates, ServiceDate serviceDate, TimeZone timeZone) {
        int days;
        if (this._excludeFutureServiceDatesInDays > 0 && (days = (int)((serviceDate.getAsDate().getTime() - System.currentTimeMillis()) / 86400000L)) > this._excludeFutureServiceDatesInDays) {
            return;
        }
        activeDates.add(new ServiceDate(serviceDate));
    }

    private static Date getServiceDateAsNoon(ServiceDate serviceDate, TimeZone timeZone) {
        Calendar c = serviceDate.getAsCalendar(timeZone);
        c.add(11, 12);
        return c.getTime();
    }
}

