/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.onebusaway.gtfs.impl.GenericDaoImpl;
import org.onebusaway.gtfs.impl.ShapePointArray;
import org.onebusaway.gtfs.impl.StopTimeArray;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableDao;

public class GtfsDaoImpl
extends GenericDaoImpl
implements GtfsMutableDao {
    private StopTimeArray stopTimes = new StopTimeArray();
    private ShapePointArray shapePoints = new ShapePointArray();
    private boolean packStopTimes = false;
    private boolean packShapePoints = false;

    public boolean isPackStopTimes() {
        return this.packStopTimes;
    }

    public void setPackStopTimes(boolean packStopTimes) {
        this.packStopTimes = packStopTimes;
    }

    public boolean isPackShapePoints() {
        return this.packShapePoints;
    }

    public void setPackShapePoints(boolean packShapePoints) {
        this.packShapePoints = packShapePoints;
    }

    @Override
    public Agency getAgencyForId(String id) {
        return this.getEntityForId(Agency.class, (Serializable)((Object)id));
    }

    @Override
    public Collection<Agency> getAllAgencies() {
        return this.getAllEntitiesForType(Agency.class);
    }

    @Override
    public Collection<ServiceCalendarDate> getAllCalendarDates() {
        return this.getAllEntitiesForType(ServiceCalendarDate.class);
    }

    @Override
    public Collection<ServiceCalendar> getAllCalendars() {
        return this.getAllEntitiesForType(ServiceCalendar.class);
    }

    @Override
    public Collection<FareAttribute> getAllFareAttributes() {
        return this.getAllEntitiesForType(FareAttribute.class);
    }

    @Override
    public Collection<FareRule> getAllFareRules() {
        return this.getAllEntitiesForType(FareRule.class);
    }

    @Override
    public Collection<FeedInfo> getAllFeedInfos() {
        return this.getAllEntitiesForType(FeedInfo.class);
    }

    @Override
    public Collection<Frequency> getAllFrequencies() {
        return this.getAllEntitiesForType(Frequency.class);
    }

    @Override
    public Collection<Route> getAllRoutes() {
        return this.getAllEntitiesForType(Route.class);
    }

    @Override
    public Collection<ShapePoint> getAllShapePoints() {
        if (this.packShapePoints) {
            return this.shapePoints;
        }
        return this.getAllEntitiesForType(ShapePoint.class);
    }

    @Override
    public Collection<StopTime> getAllStopTimes() {
        if (this.packStopTimes) {
            return this.stopTimes;
        }
        return this.getAllEntitiesForType(StopTime.class);
    }

    @Override
    public Collection<Stop> getAllStops() {
        return this.getAllEntitiesForType(Stop.class);
    }

    @Override
    public Collection<Transfer> getAllTransfers() {
        return this.getAllEntitiesForType(Transfer.class);
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this.getAllEntitiesForType(Trip.class);
    }

    @Override
    public ServiceCalendarDate getCalendarDateForId(int id) {
        return this.getEntityForId(ServiceCalendarDate.class, Integer.valueOf(id));
    }

    @Override
    public ServiceCalendar getCalendarForId(int id) {
        return this.getEntityForId(ServiceCalendar.class, Integer.valueOf(id));
    }

    @Override
    public FareAttribute getFareAttributeForId(AgencyAndId id) {
        return this.getEntityForId(FareAttribute.class, id);
    }

    @Override
    public FareRule getFareRuleForId(int id) {
        return this.getEntityForId(FareRule.class, Integer.valueOf(id));
    }

    @Override
    public FeedInfo getFeedInfoForId(int id) {
        return this.getEntityForId(FeedInfo.class, Integer.valueOf(id));
    }

    @Override
    public Frequency getFrequencyForId(int id) {
        return this.getEntityForId(Frequency.class, Integer.valueOf(id));
    }

    @Override
    public Collection<Pathway> getAllPathways() {
        return this.getAllEntitiesForType(Pathway.class);
    }

    @Override
    public Pathway getPathwayForId(AgencyAndId id) {
        return this.getEntityForId(Pathway.class, id);
    }

    @Override
    public Route getRouteForId(AgencyAndId id) {
        return this.getEntityForId(Route.class, id);
    }

    @Override
    public ShapePoint getShapePointForId(int id) {
        if (this.packShapePoints) {
            return this.shapePoints.get(id);
        }
        return this.getEntityForId(ShapePoint.class, Integer.valueOf(id));
    }

    @Override
    public Stop getStopForId(AgencyAndId id) {
        return this.getEntityForId(Stop.class, id);
    }

    @Override
    public StopTime getStopTimeForId(int id) {
        if (this.packStopTimes) {
            return this.stopTimes.get(id);
        }
        return this.getEntityForId(StopTime.class, Integer.valueOf(id));
    }

    @Override
    public Transfer getTransferForId(int id) {
        return this.getEntityForId(Transfer.class, Integer.valueOf(id));
    }

    @Override
    public Trip getTripForId(AgencyAndId id) {
        return this.getEntityForId(Trip.class, id);
    }

    @Override
    public <K, V> Map<K, V> getEntitiesByIdForEntityType(Class<K> keyType, Class<V> entityType) {
        this.noKeyCheck(keyType);
        return super.getEntitiesByIdForEntityType(keyType, entityType);
    }

    @Override
    public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            return this.stopTimes;
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            return this.shapePoints;
        }
        return super.getAllEntitiesForType(type);
    }

    @Override
    public <T> T getEntityForId(Class<T> type, Serializable id) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            return (T)this.stopTimes.get((Integer)id);
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            return (T)this.shapePoints.get((Integer)id);
        }
        return super.getEntityForId(type, id);
    }

    @Override
    public void saveEntity(Object entity) {
        if (this.packStopTimes && entity.getClass().equals(StopTime.class)) {
            this.stopTimes.add((StopTime)entity);
            return;
        }
        if (this.packShapePoints && entity.getClass().equals(ShapePoint.class)) {
            this.shapePoints.add((ShapePoint)entity);
            return;
        }
        super.saveEntity(entity);
    }

    @Override
    public <T> void clearAllEntitiesForType(Class<T> type) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            this.stopTimes.clear();
            return;
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            this.shapePoints.clear();
            return;
        }
        super.clearAllEntitiesForType(type);
    }

    @Override
    public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
        if (this.packStopTimes && entity.getClass().equals(StopTime.class)) {
            throw new UnsupportedOperationException();
        }
        if (this.packShapePoints && entity.getClass().equals(ShapePoint.class)) {
            throw new UnsupportedOperationException();
        }
        super.removeEntity(entity);
    }

    @Override
    public void close() {
        if (this.packStopTimes) {
            this.stopTimes.trimToSize();
        }
        if (this.packShapePoints) {
            this.shapePoints.trimToSize();
        }
        super.close();
    }

    private <K> void noKeyCheck(Class<K> keyType) {
        if (this.packStopTimes && keyType.equals(StopTime.class)) {
            throw new UnsupportedOperationException();
        }
        if (this.packShapePoints && keyType.equals(ShapePoint.class)) {
            throw new UnsupportedOperationException();
        }
    }
}

