/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.StopTimeProxy;
import org.onebusaway.gtfs.model.Trip;

public class StopTimeArray
extends AbstractList<StopTime> {
    private int size = 0;
    private Trip[] trips = new Trip[0];
    private Stop[] stops = new Stop[0];
    private int[] arrivalTimes = new int[0];
    private int[] departureTimes = new int[0];
    private int[] timepoints = new int[0];
    private int[] stopSequences = new int[0];
    private String[] stopHeadsigns = new String[0];
    private String[] routeShortNames = new String[0];
    private int[] pickupTypes = new int[0];
    private int[] dropOffTypes = new int[0];
    private double[] shapeDistTraveled = new double[0];

    public void trimToSize() {
        this.setLength(this.size);
    }

    @Override
    public boolean add(StopTime stopTime) {
        int index = this.size++;
        this.ensureCapacity(this.size);
        this.trips[index] = stopTime.getTrip();
        this.stops[index] = stopTime.getStop();
        this.arrivalTimes[index] = stopTime.getArrivalTime();
        this.departureTimes[index] = stopTime.getDepartureTime();
        this.timepoints[index] = stopTime.getTimepoint();
        this.stopSequences[index] = stopTime.getStopSequence();
        this.stopHeadsigns[index] = stopTime.getStopHeadsign();
        this.routeShortNames[index] = stopTime.getRouteShortName();
        this.pickupTypes[index] = stopTime.getPickupType();
        this.dropOffTypes[index] = stopTime.getDropOffType();
        this.shapeDistTraveled[index] = stopTime.getShapeDistTraveled();
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.setLength(0);
    }

    @Override
    public Iterator<StopTime> iterator() {
        return new StopTimeIterator();
    }

    @Override
    public StopTime get(int index) {
        if (index < 0 || index >= this.size) {
            throw new NoSuchElementException();
        }
        StopTime stopTime = new StopTime();
        stopTime.setProxy(new StopTimeProxyImpl(index));
        return stopTime;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void ensureCapacity(int capacity) {
        if (this.trips.length < capacity) {
            int newLength = Math.max(8, this.trips.length << 2);
            this.setLength(newLength);
        }
    }

    private void setLength(int newLength) {
        this.trips = Arrays.copyOf(this.trips, newLength);
        this.stops = Arrays.copyOf(this.stops, newLength);
        this.arrivalTimes = Arrays.copyOf(this.arrivalTimes, newLength);
        this.departureTimes = Arrays.copyOf(this.departureTimes, newLength);
        this.timepoints = Arrays.copyOf(this.timepoints, newLength);
        this.stopSequences = Arrays.copyOf(this.stopSequences, newLength);
        this.stopHeadsigns = Arrays.copyOf(this.stopHeadsigns, newLength);
        this.routeShortNames = Arrays.copyOf(this.routeShortNames, newLength);
        this.pickupTypes = Arrays.copyOf(this.pickupTypes, newLength);
        this.dropOffTypes = Arrays.copyOf(this.dropOffTypes, newLength);
        this.shapeDistTraveled = Arrays.copyOf(this.shapeDistTraveled, newLength);
    }

    private class StopTimeProxyImpl
    implements StopTimeProxy {
        private final int index;

        public StopTimeProxyImpl(int index) {
            this.index = index;
        }

        @Override
        public Integer getId() {
            return this.index;
        }

        @Override
        public void setId(Integer id) {
        }

        @Override
        public Trip getTrip() {
            return StopTimeArray.this.trips[this.index];
        }

        @Override
        public void setTrip(Trip trip) {
            ((StopTimeArray)StopTimeArray.this).trips[this.index] = trip;
        }

        @Override
        public int getStopSequence() {
            return StopTimeArray.this.stopSequences[this.index];
        }

        @Override
        public void setStopSequence(int stopSequence) {
            ((StopTimeArray)StopTimeArray.this).stopSequences[this.index] = stopSequence;
        }

        @Override
        public Stop getStop() {
            return StopTimeArray.this.stops[this.index];
        }

        @Override
        public void setStop(Stop stop) {
            ((StopTimeArray)StopTimeArray.this).stops[this.index] = stop;
        }

        @Override
        public boolean isArrivalTimeSet() {
            return StopTimeArray.this.arrivalTimes[this.index] != -999;
        }

        @Override
        public int getArrivalTime() {
            return StopTimeArray.this.arrivalTimes[this.index];
        }

        @Override
        public void setArrivalTime(int arrivalTime) {
            ((StopTimeArray)StopTimeArray.this).arrivalTimes[this.index] = arrivalTime;
        }

        @Override
        public void clearArrivalTime() {
            ((StopTimeArray)StopTimeArray.this).arrivalTimes[this.index] = -999;
        }

        @Override
        public boolean isDepartureTimeSet() {
            return StopTimeArray.this.departureTimes[this.index] != -999;
        }

        @Override
        public int getDepartureTime() {
            return StopTimeArray.this.departureTimes[this.index];
        }

        @Override
        public void setDepartureTime(int departureTime) {
            ((StopTimeArray)StopTimeArray.this).departureTimes[this.index] = departureTime;
        }

        @Override
        public void clearDepartureTime() {
            ((StopTimeArray)StopTimeArray.this).departureTimes[this.index] = -999;
        }

        @Override
        public int getTimepoint() {
            return StopTimeArray.this.timepoints[this.index];
        }

        @Override
        public void setTimepoint(int timepoint) {
            ((StopTimeArray)StopTimeArray.this).timepoints[this.index] = timepoint;
        }

        @Override
        public String getStopHeadsign() {
            return StopTimeArray.this.stopHeadsigns[this.index];
        }

        @Override
        public void setStopHeadsign(String headSign) {
            ((StopTimeArray)StopTimeArray.this).stopHeadsigns[this.index] = headSign;
        }

        @Override
        public String getRouteShortName() {
            return StopTimeArray.this.routeShortNames[this.index];
        }

        @Override
        public void setRouteShortName(String routeShortName) {
            ((StopTimeArray)StopTimeArray.this).routeShortNames[this.index] = routeShortName;
        }

        @Override
        public int getPickupType() {
            return StopTimeArray.this.pickupTypes[this.index];
        }

        @Override
        public void setPickupType(int pickupType) {
            ((StopTimeArray)StopTimeArray.this).pickupTypes[this.index] = pickupType;
        }

        @Override
        public int getDropOffType() {
            return StopTimeArray.this.dropOffTypes[this.index];
        }

        @Override
        public void setDropOffType(int dropOffType) {
            ((StopTimeArray)StopTimeArray.this).dropOffTypes[this.index] = dropOffType;
        }

        @Override
        public boolean isShapeDistTraveledSet() {
            return StopTimeArray.this.shapeDistTraveled[this.index] != -999.0;
        }

        @Override
        public double getShapeDistTraveled() {
            return StopTimeArray.this.shapeDistTraveled[this.index];
        }

        @Override
        public void setShapeDistTraveled(double shapeDistTraveled) {
            ((StopTimeArray)StopTimeArray.this).shapeDistTraveled[this.index] = shapeDistTraveled;
        }

        @Override
        public void clearShapeDistTraveled() {
            ((StopTimeArray)StopTimeArray.this).shapeDistTraveled[this.index] = -999.0;
        }
    }

    private class StopTimeIterator
    implements Iterator<StopTime> {
        private int index = 0;

        private StopTimeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < StopTimeArray.this.size;
        }

        @Override
        public StopTime next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StopTime stopTime = new StopTime();
            stopTime.setProxy(new StopTimeProxyImpl(this.index));
            ++this.index;
            return stopTime;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

