/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.TripAgencyIdFieldMappingFactory;

@CsvFields(filename="trips.txt")
public final class Trip
extends IdentityBean<AgencyAndId> {
    private static final long serialVersionUID = 1L;
    @CsvField(name="trip_id", mapping=TripAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(name="route_id", mapping=EntityFieldMappingFactory.class, order=-1)
    private Route route;
    @CsvField(mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId serviceId;
    @CsvField(optional=true)
    private String tripShortName;
    @CsvField(optional=true)
    private String tripHeadsign;
    @CsvField(optional=true)
    private String routeShortName;
    @CsvField(optional=true)
    private String directionId;
    @CsvField(optional=true)
    private String blockId;
    @CsvField(optional=true, mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId shapeId;
    @CsvField(optional=true, defaultValue="0")
    private int wheelchairAccessible = 0;
    @Deprecated
    @CsvField(optional=true, defaultValue="0")
    private int tripBikesAllowed = 0;
    @CsvField(optional=true, defaultValue="0")
    private int bikesAllowed = 0;

    public Trip() {
    }

    public Trip(Trip obj) {
        this.id = obj.id;
        this.route = obj.route;
        this.serviceId = obj.serviceId;
        this.tripShortName = obj.tripShortName;
        this.tripHeadsign = obj.tripHeadsign;
        this.routeShortName = obj.routeShortName;
        this.directionId = obj.directionId;
        this.blockId = obj.blockId;
        this.shapeId = obj.shapeId;
        this.wheelchairAccessible = obj.wheelchairAccessible;
        this.tripBikesAllowed = obj.tripBikesAllowed;
        this.bikesAllowed = obj.bikesAllowed;
    }

    @Override
    public AgencyAndId getId() {
        return this.id;
    }

    @Override
    public void setId(AgencyAndId id) {
        this.id = id;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public AgencyAndId getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(AgencyAndId serviceId) {
        this.serviceId = serviceId;
    }

    public String getTripShortName() {
        return this.tripShortName;
    }

    public void setTripShortName(String tripShortName) {
        this.tripShortName = tripShortName;
    }

    public String getTripHeadsign() {
        return this.tripHeadsign;
    }

    public void setTripHeadsign(String tripHeadsign) {
        this.tripHeadsign = tripHeadsign;
    }

    public String getRouteShortName() {
        return this.routeShortName;
    }

    public void setRouteShortName(String routeShortName) {
        this.routeShortName = routeShortName;
    }

    public String getDirectionId() {
        return this.directionId;
    }

    public void setDirectionId(String directionId) {
        this.directionId = directionId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public AgencyAndId getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(AgencyAndId shapeId) {
        this.shapeId = shapeId;
    }

    public void setWheelchairAccessible(int wheelchairAccessible) {
        this.wheelchairAccessible = wheelchairAccessible;
    }

    public int getWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    @Deprecated
    public void setTripBikesAllowed(int tripBikesAllowed) {
        this.tripBikesAllowed = tripBikesAllowed;
    }

    @Deprecated
    public int getTripBikesAllowed() {
        return this.tripBikesAllowed;
    }

    public int getBikesAllowed() {
        return this.bikesAllowed;
    }

    public void setBikesAllowed(int bikesAllowed) {
        this.bikesAllowed = bikesAllowed;
    }

    public String toString() {
        return "<Trip " + this.getId() + ">";
    }
}

