/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.services.calendar;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceIdIntervals;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public interface CalendarService {
    public Set<AgencyAndId> getServiceIds();

    public Set<ServiceDate> getServiceDatesForServiceId(AgencyAndId var1);

    public Set<AgencyAndId> getServiceIdsOnDate(ServiceDate var1);

    public TimeZone getTimeZoneForAgencyId(String var1);

    public LocalizedServiceId getLocalizedServiceIdForAgencyAndServiceId(String var1, AgencyAndId var2);

    public List<Date> getDatesForLocalizedServiceId(LocalizedServiceId var1);

    public boolean isLocalizedServiceIdActiveOnDate(LocalizedServiceId var1, Date var2);

    public List<Date> getServiceDatesWithinRange(LocalizedServiceId var1, ServiceInterval var2, Date var3, Date var4);

    public Map<LocalizedServiceId, List<Date>> getServiceDatesWithinRange(ServiceIdIntervals var1, Date var2, Date var3);

    public List<Date> getServiceDateDeparturesWithinRange(LocalizedServiceId var1, ServiceInterval var2, Date var3, Date var4);

    public Map<LocalizedServiceId, List<Date>> getServiceDateDeparturesWithinRange(ServiceIdIntervals var1, Date var2, Date var3);

    public List<Date> getServiceDateArrivalsWithinRange(LocalizedServiceId var1, ServiceInterval var2, Date var3, Date var4);

    public Map<LocalizedServiceId, List<Date>> getServiceDateArrivalsWithinRange(ServiceIdIntervals var1, Date var2, Date var3);

    public List<Date> getNextDepartureServiceDates(LocalizedServiceId var1, ServiceInterval var2, long var3);

    public Map<LocalizedServiceId, List<Date>> getNextDepartureServiceDates(ServiceIdIntervals var1, long var2);

    public List<Date> getPreviousArrivalServiceDates(LocalizedServiceId var1, ServiceInterval var2, long var3);

    public Map<LocalizedServiceId, List<Date>> getPreviousArrivalServiceDates(ServiceIdIntervals var1, long var2);
}

