/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDaoImpl
implements GenericMutableDao {
    private final Logger _log = LoggerFactory.getLogger(GenericDaoImpl.class);
    private Map<Class<?>, Map<Object, Object>> _entitiesByClassAndId = new HashMap();
    private Map<Class<?>, EntityHandler<Serializable>> _handlers = new HashMap();
    private boolean _generateIds = true;

    public void setGenerateIds(boolean generateIds) {
        this._generateIds = generateIds;
    }

    public Set<Class<?>> getEntityClasses() {
        return this._entitiesByClassAndId.keySet();
    }

    public void clear() {
        this._entitiesByClassAndId.clear();
    }

    public <K, V> Map<K, V> getEntitiesByIdForEntityType(Class<K> keyType, Class<V> entityType) {
        return this._entitiesByClassAndId.get(entityType);
    }

    @Override
    public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
        Map<Object, Object> entitiesById = this._entitiesByClassAndId.get(type);
        if (entitiesById == null) {
            return new ArrayList();
        }
        return entitiesById.values();
    }

    @Override
    public <T> T getEntityForId(Class<T> type, Serializable id) {
        Map<Object, Object> byId = this._entitiesByClassAndId.get(type);
        if (byId == null) {
            this._log.debug("no stored entities type {}", type);
            return null;
        }
        return (T)byId.get(id);
    }

    @Override
    public void saveEntity(Object entity) {
        Object id;
        Object prev;
        Class<?> c = entity.getClass();
        EntityHandler<Serializable> handler = this._handlers.get(c);
        if (handler == null) {
            handler = this.createEntityHandler(c);
            this._handlers.put(c, handler);
        }
        IdentityBean bean = (IdentityBean)entity;
        handler.handle(bean);
        Map<Object, Object> byId = this._entitiesByClassAndId.get(c);
        if (byId == null) {
            byId = new HashMap<Object, Object>();
            this._entitiesByClassAndId.put(c, byId);
        }
        if ((prev = byId.put(id = bean.getId(), entity)) != null) {
            String string = String.valueOf(String.valueOf(c));
            String string2 = String.valueOf(String.valueOf(id));
            String string3 = String.valueOf(String.valueOf(prev));
            String string4 = String.valueOf(String.valueOf(entity));
            this._log.warn(new StringBuilder(52 + string.length() + string2.length() + string3.length() + string4.length()).append("entity with id already exists: class=").append(string).append(" id=").append(string2).append(" prev=").append(string3).append(" new=").append(string4).toString());
        }
    }

    @Override
    public void updateEntity(Object entity) {
    }

    @Override
    public void saveOrUpdateEntity(Object entity) {
        IdentityBean bean = (IdentityBean)entity;
        Object existing = this.getEntityForId(entity.getClass(), (Serializable)bean.getId());
        if (existing == entity) {
            return;
        }
        this.saveEntity(entity);
    }

    @Override
    public <T> void clearAllEntitiesForType(Class<T> type) {
        this._entitiesByClassAndId.remove(type);
    }

    @Override
    public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
        Class<?> type = entity.getClass();
        K id = entity.getId();
        Map<Object, Object> byId = this._entitiesByClassAndId.get(type);
        if (byId == null) {
            String string = String.valueOf(String.valueOf(type));
            this._log.warn(new StringBuilder(24 + string.length()).append("no stored entities type ").append(string).toString());
            return;
        }
        Object found = byId.remove(id);
        if (found == null) {
            String string = String.valueOf(String.valueOf(type));
            String string2 = String.valueOf(String.valueOf(id));
            this._log.warn(new StringBuilder(35 + string.length() + string2.length()).append("no stored entity with type ").append(string).append(" and id ").append(string2).toString());
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private EntityHandler<?> createEntityHandler(Class<?> entityType) {
        if (this._generateIds) {
            try {
                Class<?> type;
                Field field = entityType.getDeclaredField("id");
                if (field != null && ((type = field.getType()).equals(Integer.class) || type.equals(Integer.TYPE))) {
                    return new GeneratedIdHandler();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new EntityHandler<Serializable>(){

            @Override
            public void handle(IdentityBean<Serializable> entity) {
            }
        };
    }

    private static class GeneratedIdHandler
    implements EntityHandler<Integer> {
        private int _maxId = 0;

        private GeneratedIdHandler() {
        }

        @Override
        public void handle(IdentityBean<Integer> entity) {
            Integer value = entity.getId();
            if (value == null || value == 0) {
                value = this._maxId + 1;
                entity.setId(value);
            }
            this._maxId = Math.max(this._maxId, value);
        }
    }

    private static interface EntityHandler<T extends Serializable> {
        public void handle(IdentityBean<T> var1);
    }
}

