/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.mappings.RouteAgencyFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.RouteAgencyIdFieldMappingFactory;

@CsvFields(filename="routes.txt", prefix="route_")
public final class Route
extends IdentityBean<AgencyAndId> {
    private static final long serialVersionUID = 1L;
    private static final int MISSING_VALUE = -999;
    @CsvField(mapping=RouteAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(name="agency_id", optional=true, mapping=RouteAgencyFieldMappingFactory.class, order=-1)
    private Agency agency;
    @CsvField(optional=true, alwaysIncludeInOutput=true)
    private String shortName;
    @CsvField(optional=true, alwaysIncludeInOutput=true)
    private String longName;
    private int type;
    @CsvField(optional=true)
    private String desc;
    @CsvField(optional=true)
    private String url;
    @CsvField(optional=true)
    private String color;
    @CsvField(optional=true)
    private String textColor;
    @Deprecated
    @CsvField(name="route_bikes_allowed", optional=true, defaultValue="0")
    private int routeBikesAllowed = 0;
    @CsvField(name="bikes_allowed", optional=true, defaultValue="0")
    private int bikesAllowed = 0;
    @CsvField(optional=true)
    private int sortOrder = -999;

    public Route() {
    }

    public Route(Route r) {
        this.id = r.id;
        this.agency = r.agency;
        this.shortName = r.shortName;
        this.longName = r.longName;
        this.desc = r.desc;
        this.type = r.type;
        this.url = r.url;
        this.color = r.color;
        this.textColor = r.textColor;
        this.bikesAllowed = r.bikesAllowed;
        this.sortOrder = r.sortOrder;
    }

    @Override
    public AgencyAndId getId() {
        return this.id;
    }

    @Override
    public void setId(AgencyAndId id) {
        this.id = id;
    }

    public Agency getAgency() {
        return this.agency;
    }

    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    @Deprecated
    public int getRouteBikesAllowed() {
        return this.routeBikesAllowed;
    }

    @Deprecated
    public void setRouteBikesAllowed(int routeBikesAllowed) {
        this.routeBikesAllowed = routeBikesAllowed;
    }

    public int getBikesAllowed() {
        return this.bikesAllowed;
    }

    public void setBikesAllowed(int bikesAllowed) {
        this.bikesAllowed = bikesAllowed;
    }

    public boolean isSortOrderSet() {
        return this.sortOrder != -999;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.id));
        String string2 = String.valueOf(String.valueOf(this.shortName));
        return new StringBuilder(9 + string.length() + string2.length()).append("<Route ").append(string).append(" ").append(string2).append(">").toString();
    }
}

