/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTimeProxy;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;

@CsvFields(filename="stop_times.txt")
public final class StopTime
extends IdentityBean<Integer>
implements Comparable<StopTime>,
StopTimeProxy {
    private static final long serialVersionUID = 1L;
    public static final int MISSING_VALUE = -999;
    @CsvField(ignore=true)
    private int id;
    @CsvField(name="trip_id", mapping=EntityFieldMappingFactory.class)
    private Trip trip;
    @CsvField(name="stop_id", mapping=EntityFieldMappingFactory.class)
    private Stop stop;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int arrivalTime = -999;
    @CsvField(optional=true, mapping=StopTimeFieldMappingFactory.class)
    private int departureTime = -999;
    @CsvField(optional=true)
    private int timepoint = -999;
    private int stopSequence;
    @CsvField(optional=true)
    private String stopHeadsign;
    @CsvField(optional=true)
    private String routeShortName;
    @CsvField(optional=true, defaultValue="0")
    private int pickupType;
    @CsvField(optional=true, defaultValue="0")
    private int dropOffType;
    @CsvField(optional=true)
    private double shapeDistTraveled = -999.0;
    @CsvField(ignore=true)
    private transient StopTimeProxy proxy = null;

    public StopTime() {
    }

    public StopTime(StopTime st) {
        this.arrivalTime = st.arrivalTime;
        this.departureTime = st.departureTime;
        this.dropOffType = st.dropOffType;
        this.id = st.id;
        this.pickupType = st.pickupType;
        this.routeShortName = st.routeShortName;
        this.shapeDistTraveled = st.shapeDistTraveled;
        this.stop = st.stop;
        this.stopHeadsign = st.stopHeadsign;
        this.stopSequence = st.stopSequence;
        this.timepoint = st.timepoint;
        this.trip = st.trip;
    }

    @Override
    public Integer getId() {
        if (this.proxy != null) {
            return this.proxy.getId();
        }
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        if (this.proxy != null) {
            this.proxy.setId(id);
            return;
        }
        this.id = id;
    }

    @Override
    public Trip getTrip() {
        if (this.proxy != null) {
            return this.proxy.getTrip();
        }
        return this.trip;
    }

    @Override
    public void setTrip(Trip trip) {
        if (this.proxy != null) {
            this.proxy.setTrip(trip);
            return;
        }
        this.trip = trip;
    }

    @Override
    public int getStopSequence() {
        if (this.proxy != null) {
            return this.proxy.getStopSequence();
        }
        return this.stopSequence;
    }

    @Override
    public void setStopSequence(int stopSequence) {
        if (this.proxy != null) {
            this.proxy.setStopSequence(stopSequence);
            return;
        }
        this.stopSequence = stopSequence;
    }

    @Override
    public Stop getStop() {
        if (this.proxy != null) {
            return this.proxy.getStop();
        }
        return this.stop;
    }

    @Override
    public void setStop(Stop stop) {
        if (this.proxy != null) {
            this.proxy.setStop(stop);
            return;
        }
        this.stop = stop;
    }

    @Override
    public boolean isArrivalTimeSet() {
        if (this.proxy != null) {
            return this.proxy.isArrivalTimeSet();
        }
        return this.arrivalTime != -999;
    }

    @Override
    public int getArrivalTime() {
        if (this.proxy != null) {
            return this.proxy.getArrivalTime();
        }
        return this.arrivalTime;
    }

    @Override
    public void setArrivalTime(int arrivalTime) {
        if (this.proxy != null) {
            this.proxy.setArrivalTime(arrivalTime);
            return;
        }
        this.arrivalTime = arrivalTime;
    }

    @Override
    public void clearArrivalTime() {
        if (this.proxy != null) {
            this.proxy.clearArrivalTime();
            return;
        }
        this.arrivalTime = -999;
    }

    @Override
    public boolean isDepartureTimeSet() {
        if (this.proxy != null) {
            return this.proxy.isDepartureTimeSet();
        }
        return this.departureTime != -999;
    }

    @Override
    public int getDepartureTime() {
        if (this.proxy != null) {
            return this.proxy.getDepartureTime();
        }
        return this.departureTime;
    }

    @Override
    public void setDepartureTime(int departureTime) {
        if (this.proxy != null) {
            this.proxy.setDepartureTime(departureTime);
            return;
        }
        this.departureTime = departureTime;
    }

    @Override
    public void clearDepartureTime() {
        if (this.proxy != null) {
            this.proxy.clearDepartureTime();
            return;
        }
        this.departureTime = -999;
    }

    @Override
    public boolean isTimepointSet() {
        if (this.proxy != null) {
            return this.proxy.isTimepointSet();
        }
        return this.timepoint != -999;
    }

    @Override
    public int getTimepoint() {
        if (this.proxy != null) {
            return this.proxy.getTimepoint();
        }
        return this.timepoint;
    }

    @Override
    public void setTimepoint(int timepoint) {
        if (this.proxy != null) {
            this.proxy.setTimepoint(timepoint);
            return;
        }
        this.timepoint = timepoint;
    }

    @Override
    public void clearTimepoint() {
        if (this.proxy != null) {
            this.proxy.clearTimepoint();
            return;
        }
        this.timepoint = -999;
    }

    @Override
    public String getStopHeadsign() {
        if (this.proxy != null) {
            return this.proxy.getStopHeadsign();
        }
        return this.stopHeadsign;
    }

    @Override
    public void setStopHeadsign(String headSign) {
        if (this.proxy != null) {
            this.proxy.setStopHeadsign(headSign);
            return;
        }
        this.stopHeadsign = headSign;
    }

    @Override
    public String getRouteShortName() {
        if (this.proxy != null) {
            return this.proxy.getRouteShortName();
        }
        return this.routeShortName;
    }

    @Override
    public void setRouteShortName(String routeShortName) {
        if (this.proxy != null) {
            this.proxy.setRouteShortName(routeShortName);
            return;
        }
        this.routeShortName = routeShortName;
    }

    @Override
    public int getPickupType() {
        if (this.proxy != null) {
            return this.proxy.getPickupType();
        }
        return this.pickupType;
    }

    @Override
    public void setPickupType(int pickupType) {
        if (this.proxy != null) {
            this.proxy.setPickupType(pickupType);
        }
        this.pickupType = pickupType;
    }

    @Override
    public int getDropOffType() {
        if (this.proxy != null) {
            return this.proxy.getDropOffType();
        }
        return this.dropOffType;
    }

    @Override
    public void setDropOffType(int dropOffType) {
        if (this.proxy != null) {
            this.proxy.setDropOffType(dropOffType);
            return;
        }
        this.dropOffType = dropOffType;
    }

    @Override
    public boolean isShapeDistTraveledSet() {
        if (this.proxy != null) {
            return this.proxy.isShapeDistTraveledSet();
        }
        return this.shapeDistTraveled != -999.0;
    }

    @Override
    public double getShapeDistTraveled() {
        if (this.proxy != null) {
            return this.proxy.getShapeDistTraveled();
        }
        return this.shapeDistTraveled;
    }

    @Override
    public void setShapeDistTraveled(double shapeDistTraveled) {
        if (this.proxy != null) {
            this.proxy.setShapeDistTraveled(shapeDistTraveled);
            return;
        }
        this.shapeDistTraveled = shapeDistTraveled;
    }

    @Override
    public void clearShapeDistTraveled() {
        if (this.proxy != null) {
            this.proxy.clearShapeDistTraveled();
            return;
        }
        this.shapeDistTraveled = -999.0;
    }

    @Override
    public int compareTo(StopTime o) {
        return this.getStopSequence() - o.getStopSequence();
    }

    public void setProxy(StopTimeProxy proxy) {
        this.proxy = proxy;
    }

    public StopTimeProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        int n = this.getStopSequence();
        String string = String.valueOf(String.valueOf(this.getStop().getId()));
        String string2 = String.valueOf(String.valueOf(this.getTrip().getId()));
        String string3 = String.valueOf(String.valueOf(StopTimeFieldMappingFactory.getSecondsAsString(this.getArrivalTime())));
        String string4 = String.valueOf(String.valueOf(StopTimeFieldMappingFactory.getSecondsAsString(this.getDepartureTime())));
        return new StringBuilder(45 + string.length() + string2.length() + string3.length() + string4.length()).append("StopTime(seq=").append(n).append(" stop=").append(string).append(" trip=").append(string2).append(" times=").append(string3).append("-").append(string4).append(")").toString();
    }
}

