/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceDate
implements Serializable,
Comparable<ServiceDate> {
    private static final long serialVersionUID = 1L;
    private static final Pattern _pattern = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})$");
    private static final NumberFormat _yearFormat = new DecimalFormat("0000");
    private static final NumberFormat _monthAndDayFormat = new DecimalFormat("00");
    private static final TimeZone _utcTimeZone = TimeZone.getTimeZone("UTC");
    private final int year;
    private final int month;
    private final int day;

    public ServiceDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public ServiceDate(ServiceDate o) {
        this(o.year, o.month, o.day);
    }

    public ServiceDate(Calendar calendar) {
        this(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public ServiceDate(Date date) {
        this(ServiceDate.getCalendarForDate(date));
    }

    public ServiceDate() {
        this(new Date());
    }

    public static ServiceDate parseString(String value) throws ParseException {
        Matcher matcher = _pattern.matcher(value);
        if (!matcher.matches()) {
            String string = String.valueOf(value);
            throw new ParseException(string.length() != 0 ? "error parsing date: ".concat(string) : new String("error parsing date: "), 0);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        return new ServiceDate(year, month, day);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date getAsDate() {
        return this.getAsDate(TimeZone.getDefault());
    }

    public Calendar getAsCalendar(TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.day);
        ServiceDate.moveCalendarToServiceDate(c);
        return c;
    }

    public Date getAsDate(TimeZone timeZone) {
        Calendar c = this.getAsCalendar(timeZone);
        return c.getTime();
    }

    public String getAsString() {
        String year = _yearFormat.format(this.year);
        String month = _monthAndDayFormat.format(this.month);
        String day = _monthAndDayFormat.format(this.day);
        String string = String.valueOf(String.valueOf(year));
        String string2 = String.valueOf(String.valueOf(month));
        String string3 = String.valueOf(String.valueOf(day));
        return new StringBuilder(0 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(string3).toString();
    }

    public ServiceDate next() {
        return this.shift(1);
    }

    public ServiceDate previous() {
        return this.shift(-1);
    }

    public ServiceDate shift(int numberOfDays) {
        Calendar c = this.getAsCalendar(_utcTimeZone);
        c.add(6, numberOfDays);
        return new ServiceDate(c);
    }

    public long difference(ServiceDate serviceDate) {
        return (serviceDate.getAsDate(_utcTimeZone).getTime() - this.getAsDate(_utcTimeZone).getTime()) / 86400000L;
    }

    @Override
    public int compareTo(ServiceDate o) {
        int c = this.year - o.year;
        if (c == 0) {
            c = this.month - o.month;
        }
        if (c == 0) {
            c = this.day - o.day;
        }
        return c;
    }

    public String toString() {
        int n = this.year;
        int n2 = this.month;
        int n3 = this.day;
        return new StringBuilder(50).append("ServiceIdDate(").append(n).append("-").append(n2).append("-").append(n3).append(")").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDate other = (ServiceDate)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    public static void moveCalendarToServiceDate(Calendar c) {
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(11, -12);
    }

    private static final Calendar getCalendarForDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }
}

