/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteWriter {
    private final Logger _log = LoggerFactory.getLogger(RouteWriter.class);
    private String ARG_ROUTES_OUTPUT_NAME;
    public File _outputLocation;

    public void setOutputLocation(File outputLocation) {
        this._outputLocation = outputLocation;
    }

    public void setRoutesOutputLocation(String routesOutputName) {
        this.ARG_ROUTES_OUTPUT_NAME = routesOutputName;
    }

    public void run(GtfsDao dao) throws IOException {
        Collection<Route> routes = dao.getAllRoutes();
        Object output = "";
        for (Route route : routes) {
            output = (String)output + route.getId().getAgencyId() + "***" + route.getId().getId() + ",";
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this._outputLocation + "/" + this.ARG_ROUTES_OUTPUT_NAME));
            writer.write((String)output);
            writer.close();
        }
        catch (IOException exception) {
            this._log.error("Issue writing " + this.ARG_ROUTES_OUTPUT_NAME);
        }
    }
}

