/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl.translation;

import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;
import org.onebusaway.gtfs.impl.translation.TranslationServiceImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AlternateStopNameException;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.Facility;
import org.onebusaway.gtfs.model.FacilityProperty;
import org.onebusaway.gtfs.model.FacilityPropertyDefinition;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Translation;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.Vehicle;
import org.onebusaway.gtfs.model.WrongWayConcurrency;
import org.onebusaway.gtfs.model.translation.PropertyTranslation;
import org.onebusaway.gtfs.model.translation.TranslationServiceData;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.translation.TranslationService;
import org.onebusaway.gtfs.services.translation.TranslationServiceDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationServiceDataFactoryImpl
implements TranslationServiceDataFactory {
    private final Logger _log = LoggerFactory.getLogger(TranslationServiceDataFactoryImpl.class);
    private static final String AGENCY_TABLE_NAME = "agency";
    private static final String STOP_TABLE_NAME = "stops";
    private static final String ROUTE_TABLE_NAME = "routes";
    private static final String TRIP_TABLE_NAME = "trips";
    private static final String STOP_TIME_TABLE_NAME = "stop_times";
    private static final String FEED_INFO_TABLE_NAME = "feed_info";
    private static final String AREA_TABLE_NAME = "area";
    private static final String VEHICLE_TABLE_NAME = "vehicle";
    private static final String FACILITY_TABLE_NAME = "facilities";
    private static final String FACILITY_PROPERTY_TABLE_NAME = "facilities_properties";
    private static final String FACILITY_PROPERTY_DEFINITION_TABLE_NAME = "facilities_properties_definitions";
    private static final String WRONG_WAY_TABLE_NAME = "wrong_way_concurrencies";
    private static final String DIRECTION_ENTRY_TABLE_NAME = "direction_entry";
    private static final String ALTERNATE_STOP_NAME_EXCEPTION_TABLE_NAME = "alternate_stop_name_exception";
    private GtfsRelationalDao _dao;

    public static TranslationService getTranslationService(GtfsRelationalDao dao) {
        TranslationServiceData data = TranslationServiceDataFactoryImpl.createData(dao);
        TranslationServiceImpl translationService = new TranslationServiceImpl();
        translationService.setData(data);
        return translationService;
    }

    public static TranslationServiceData createData(GtfsRelationalDao dao) {
        TranslationServiceDataFactoryImpl factory = new TranslationServiceDataFactoryImpl();
        factory.setDao(dao);
        return factory.getTranslationServiceData();
    }

    public void setDao(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    @Override
    public TranslationServiceData getTranslationServiceData() {
        if (this._dao.getAllFeedInfos().isEmpty()) {
            this._log.warn("No feed_info present, there will be no translations available.");
            return null;
        }
        TranslationServiceData data = new TranslationServiceData();
        FeedInfo feedInfo = this._dao.getAllFeedInfos().iterator().next();
        if (feedInfo.getDefaultLang() != null) {
            data.setFeedLanguage(feedInfo.getDefaultLang());
        } else {
            data.setFeedLanguage(feedInfo.getLang());
        }
        for (Translation translation : this._dao.getAllTranslations()) {
            Class<?> type = this.getEntityTypeForTableName(translation.getTableName());
            if (type == null) {
                this._log.error("No entity type for table_name {}, skipping.", (Object)translation.getTableName());
                continue;
            }
            String propertyName = this.getPropertyNameByClassAndCsvName(type, translation.getFieldName());
            if (propertyName == null) {
                this._log.error("No property for field_name {}, skipping.", (Object)translation.getFieldName());
                continue;
            }
            PropertyTranslation propertyTranslation = new PropertyTranslation(propertyName, translation);
            data.putTranslation(type, translation.getLanguage(), propertyTranslation);
        }
        return data;
    }

    private Class<?> getEntityTypeForTableName(String name) {
        switch (name) {
            case "agency": {
                return Agency.class;
            }
            case "area": {
                return Area.class;
            }
            case "stops": {
                return Stop.class;
            }
            case "routes": {
                return Route.class;
            }
            case "trips": {
                return Trip.class;
            }
            case "stop_times": {
                return StopTime.class;
            }
            case "feed_info": {
                return FeedInfo.class;
            }
            case "vehicle": {
                return Vehicle.class;
            }
            case "facilities": {
                return Facility.class;
            }
            case "facilities_properties": {
                return FacilityProperty.class;
            }
            case "facilities_properties_definitions": {
                return FacilityPropertyDefinition.class;
            }
            case "wrong_way_concurrencies": {
                return WrongWayConcurrency.class;
            }
            case "direction_entry": {
                return DirectionEntry.class;
            }
            case "alternate_stop_name_exception": {
                return AlternateStopNameException.class;
            }
        }
        return null;
    }

    private String getPropertyNameByClassAndCsvName(Class<?> type, String csvName) {
        DefaultEntitySchemaFactory factory = GtfsEntitySchemaFactory.createEntitySchemaFactory();
        EntitySchema schema = factory.getSchema(type);
        for (FieldMapping field : schema.getFields()) {
            SingleFieldMapping mapping;
            if (!(field instanceof SingleFieldMapping) || !csvName.equals((mapping = (SingleFieldMapping)field).getCsvFieldName())) continue;
            return mapping.getObjFieldName();
        }
        return null;
    }
}

