/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.AgencyAndId;

public class LocalizedServiceId
implements Serializable,
Comparable<LocalizedServiceId> {
    private static final long serialVersionUID = 1L;
    private final AgencyAndId id;
    private final TimeZone timeZone;

    public LocalizedServiceId(AgencyAndId serviceId, TimeZone timeZone) {
        if (serviceId == null) {
            throw new IllegalArgumentException("serviceId cannot be null");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("timeZone cannot be null");
        }
        this.id = serviceId;
        this.timeZone = (TimeZone)timeZone.clone();
    }

    public AgencyAndId getId() {
        return this.id;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "ServiceId(id=" + String.valueOf(this.id) + " timeZone=" + this.timeZone.getID() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalizedServiceId other = (LocalizedServiceId)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone));
    }

    @Override
    public int compareTo(LocalizedServiceId o) {
        int rc = this.id.compareTo(o.id);
        if (rc == 0) {
            rc = this.timeZone.getID().compareTo(o.getTimeZone().getID());
        }
        return rc;
    }
}

