/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.geojson.Feature;
import org.geojson.FeatureCollection;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Location;

public class LocationsGeoJSONReader {
    private final Reader reader;
    private final String defaultAgencyId;

    public LocationsGeoJSONReader(Reader reader, String defaultAgencyId) {
        this.defaultAgencyId = defaultAgencyId;
        this.reader = reader;
    }

    public Collection<Location> read() throws IOException {
        FeatureCollection featureCollection = (FeatureCollection)new ObjectMapper().readValue(this.reader, FeatureCollection.class);
        ArrayList<Location> locations = new ArrayList<Location>(featureCollection.getFeatures().size());
        for (Feature feature : featureCollection.getFeatures()) {
            Location location = new Location();
            location.setId(new AgencyAndId(this.defaultAgencyId, feature.getId()));
            location.setGeometry(feature.getGeometry());
            location.setName((String)feature.getProperties().get("stop_name"));
            location.setDescription((String)feature.getProperties().get("stop_description"));
            location.setUrl((String)feature.getProperties().get("stop_url"));
            location.setZoneId((String)feature.getProperties().get("zone_id"));
            locations.add(location);
        }
        return locations;
    }
}

