/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class FareProductFieldMappingFactory
implements FieldMappingFactory {
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FareProductFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    public static AgencyAndId fareProductId(String agencyId, String fareProductId, String riderCategoryId, String fareMediumId) {
        String primaryKey = FareProductFieldMappingFactory.fareProductPrimaryKey(fareProductId, riderCategoryId, fareMediumId);
        return new AgencyAndId(agencyId, primaryKey);
    }

    static String fareProductPrimaryKey(String fareProductId, String riderCategoryId, String fareMediumId) {
        return String.format("id=%s|category=%s|medium=%s", fareProductId, riderCategoryId, fareMediumId);
    }

    private static class FareProductFieldMapping
    extends AbstractFieldMapping {
        public FareProductFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
            String productId = (String)csvValues.get("fare_product_id");
            String categoryId = this.blankToNull(csvValues, "rider_category_id");
            String mediumId = this.blankToNull(csvValues, "fare_medium_id");
            String primaryKey = FareProductFieldMappingFactory.fareProductPrimaryKey(productId, categoryId, mediumId);
            String agencyId = ctx.getAgencyForEntity(FareProduct.class, primaryKey);
            AgencyAndId id = FareProductFieldMappingFactory.fareProductId(agencyId, productId, categoryId, mediumId);
            FareProduct fareProduct = (FareProduct)ctx.getEntity(FareProduct.class, id);
            object.setPropertyValue(this._objFieldName, (Object)fareProduct);
        }

        private String blankToNull(Map<String, Object> csvValues, String rider_category_id) {
            String value = (String)csvValues.get(rider_category_id);
            if (value == null || value.isEmpty()) {
                return null;
            }
            return value;
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            throw new RuntimeException("Converting a FareProduct back to CSV is not supported yet.");
        }
    }
}

