/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.ParseException;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.InvalidValueEntityException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.calendar.ServiceDate;

public class ServiceDateFieldMappingFactory
implements FieldMappingFactory {
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, required);
    }

    private static class FieldMappingImpl
    extends AbstractFieldMapping
    implements Converter {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            try {
                ServiceDate date = ServiceDate.parseString(value.toString());
                object.setPropertyValue(this._objFieldName, (Object)date);
            }
            catch (ParseException ex) {
                throw new InvalidValueEntityException(this._entityType, this._csvFieldName, value.toString());
            }
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            ServiceDate date = (ServiceDate)object.getPropertyValue(this._objFieldName);
            if (date == null) {
                return;
            }
            String value = date.getAsString();
            csvValues.put(this._csvFieldName, value);
        }

        public Object convert(Class type, Object value) {
            if (type == ServiceDate.class) {
                try {
                    return ServiceDate.parseString(value.toString());
                }
                catch (ParseException ex) {
                    throw new InvalidValueEntityException(this._entityType, this._csvFieldName, value.toString());
                }
            }
            throw new ConversionException("Could not convert " + String.valueOf(value) + " of type " + String.valueOf(value.getClass()) + " to " + String.valueOf(type));
        }
    }
}

