/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.services;

import java.util.List;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsDao;

public interface GtfsRelationalDao
extends GtfsDao {
    public List<String> getTripAgencyIdsReferencingServiceId(AgencyAndId var1);

    public List<Route> getRoutesForAgency(Agency var1);

    public List<Stop> getStopsForStation(Stop var1);

    public List<Stop> getStopsForZoneId(String var1);

    public List<Trip> getTripsForRoute(Route var1);

    public List<Trip> getTripsForShapeId(AgencyAndId var1);

    public List<Trip> getTripsForServiceId(AgencyAndId var1);

    public List<Trip> getTripsForBlockId(AgencyAndId var1);

    public List<StopTime> getStopTimesForTrip(Trip var1);

    public List<StopTime> getStopTimesForStop(Stop var1);

    public List<AgencyAndId> getAllShapeIds();

    public List<ShapePoint> getShapePointsForShapeId(AgencyAndId var1);

    public List<Frequency> getFrequenciesForTrip(Trip var1);

    public List<AgencyAndId> getAllServiceIds();

    public ServiceCalendar getCalendarForServiceId(AgencyAndId var1);

    public List<ServiceCalendarDate> getCalendarDatesForServiceId(AgencyAndId var1);

    public List<FareRule> getFareRulesForFareAttribute(FareAttribute var1);

    public List<FareRule> getFareRulesForRoute(Route var1);

    public List<FareRule> getFareRulesForZoneId(String var1);

    public List<Ridership> getRidershipForTrip(AgencyAndId var1);
}

