/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.services;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.Block;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Level;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.LocationGroupElement;
import org.onebusaway.gtfs.model.Network;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.RouteShape;
import org.onebusaway.gtfs.model.RouteStop;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopArea;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Translation;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.Vehicle;
import org.onebusaway.gtfs.model.WrongWayConcurrency;
import org.onebusaway.gtfs.services.GenericDao;

public interface GtfsDao
extends GenericDao {
    public Collection<Agency> getAllAgencies();

    public Agency getAgencyForId(String var1);

    public Collection<ServiceCalendar> getAllCalendars();

    public ServiceCalendar getCalendarForId(int var1);

    public Collection<ServiceCalendarDate> getAllCalendarDates();

    public ServiceCalendarDate getCalendarDateForId(int var1);

    public Collection<FareAttribute> getAllFareAttributes();

    public FareAttribute getFareAttributeForId(AgencyAndId var1);

    public Collection<FareLegRule> getAllFareLegRules();

    public Collection<FareProduct> getAllFareProducts();

    public FareProduct getFareProductForId(AgencyAndId var1);

    public Collection<FareMedium> getAllFareMedia();

    public Collection<RiderCategory> getAllRiderCategories();

    public Collection<FareRule> getAllFareRules();

    public FareRule getFareRuleForId(int var1);

    public Collection<FareTransferRule> getAllFareTransferRules();

    public Collection<FeedInfo> getAllFeedInfos();

    public FeedInfo getFeedInfoForId(String var1);

    public Collection<Frequency> getAllFrequencies();

    public Frequency getFrequencyForId(int var1);

    public Collection<Pathway> getAllPathways();

    public Pathway getPathwayForId(AgencyAndId var1);

    public Collection<Level> getAllLevels();

    public Level getLevelForId(AgencyAndId var1);

    public Collection<Route> getAllRoutes();

    public Collection<RouteStop> getAllRouteStops();

    public Collection<RouteShape> getAllRouteShapes();

    public Route getRouteForId(AgencyAndId var1);

    public Collection<ShapePoint> getAllShapePoints();

    public ShapePoint getShapePointForId(int var1);

    public Collection<Stop> getAllStops();

    public Stop getStopForId(AgencyAndId var1);

    public Collection<StopTime> getAllStopTimes();

    public StopTime getStopTimeForId(int var1);

    public Collection<Transfer> getAllTransfers();

    public Transfer getTransferForId(int var1);

    public Collection<Trip> getAllTrips();

    public Trip getTripForId(AgencyAndId var1);

    public Collection<Block> getAllBlocks();

    public Block getBlockForId(int var1);

    public Collection<Ridership> getAllRiderships();

    public Collection<Vehicle> getAllVehicles();

    public Vehicle getVehicleForId(AgencyAndId var1);

    public Collection<Area> getAllAreas();

    @Deprecated
    public Collection<LocationGroupElement> getAllLocationGroupElements();

    public Collection<LocationGroup> getAllLocationGroups();

    public Collection<StopAreaElement> getAllStopAreaElements();

    public Collection<StopArea> getAllStopAreas();

    public Collection<Location> getAllLocations();

    public Collection<BookingRule> getAllBookingRules();

    public Collection<Translation> getAllTranslations();

    public Collection<Network> getAllNetworks();

    public Collection<DirectionEntry> getAllDirectionEntries();

    public Collection<WrongWayConcurrency> getAllWrongWayConcurrencies();

    default public boolean hasFaresV1() {
        return Stream.of(this.getAllFareAttributes(), this.getAllFareRules()).flatMap(Collection::stream).findAny().isPresent();
    }

    default public boolean hasFaresV2() {
        return Stream.of(this.getAllFareProducts(), this.getAllFareLegRules(), this.getAllFareTransferRules()).flatMap(Collection::stream).findAny().isPresent();
    }

    public List<String> getOptionalMetadataFilenames();

    public boolean hasMetadata(String var1);

    public String getMetadata(String var1);

    public void addMetadata(String var1, String var2);
}

