/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Note;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.TripAgencyIdFieldMappingFactory;

@CsvFields(filename="trips.txt")
public final class Trip
extends IdentityBean<AgencyAndId> {
    private static final long serialVersionUID = 3L;
    @CsvField(name="trip_id", mapping=TripAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(name="route_id", mapping=EntityFieldMappingFactory.class, order=-1)
    private Route route;
    @CsvField(mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId serviceId;
    @CsvField(optional=true)
    private String tripShortName;
    @CsvField(optional=true)
    private String tripHeadsign;
    @CsvField(optional=true)
    private String directionId;
    @CsvField(optional=true)
    private String blockId;
    @CsvField(optional=true, mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId shapeId;
    @CsvField(optional=true, defaultValue="0")
    private int wheelchairAccessible = 0;
    @CsvField(optional=true, defaultValue="0")
    private int bikesAllowed = 0;
    @CsvField(optional=true)
    private Double meanDurationFactor;
    @CsvField(optional=true)
    private Double meanDurationOffset;
    @CsvField(optional=true)
    private Double safeDurationFactor;
    @CsvField(optional=true)
    private Double safeDurationOffset;
    @CsvField(optional=true, defaultValue="0")
    private int carsAllowed = 0;
    @CsvField(optional=true, name="note_id", mapping=EntityFieldMappingFactory.class, order=-1)
    private Note note;
    @CsvField(optional=true, name="peak_offpeak")
    private int peakOffpeak;
    @CsvField(optional=true, name="mta_trip_id")
    private String mtaTripId;
    @CsvField(optional=true, name="boarding_type")
    private int boardingType;

    public Trip() {
    }

    public Trip(Trip obj) {
        this.id = obj.id;
        this.route = obj.route;
        this.serviceId = obj.serviceId;
        this.tripShortName = obj.tripShortName;
        this.tripHeadsign = obj.tripHeadsign;
        this.directionId = obj.directionId;
        this.blockId = obj.blockId;
        this.shapeId = obj.shapeId;
        this.wheelchairAccessible = obj.wheelchairAccessible;
        this.meanDurationFactor = obj.meanDurationFactor;
        this.meanDurationOffset = obj.meanDurationOffset;
        this.safeDurationFactor = obj.safeDurationFactor;
        this.safeDurationOffset = obj.safeDurationOffset;
        this.bikesAllowed = obj.bikesAllowed;
        this.carsAllowed = obj.carsAllowed;
        this.note = obj.note;
        this.peakOffpeak = obj.peakOffpeak;
        this.mtaTripId = obj.mtaTripId;
        this.boardingType = obj.boardingType;
    }

    @Override
    public AgencyAndId getId() {
        return this.id;
    }

    @Override
    public void setId(AgencyAndId id) {
        this.id = id;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public AgencyAndId getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(AgencyAndId serviceId) {
        this.serviceId = serviceId;
    }

    public String getTripShortName() {
        return this.tripShortName;
    }

    public void setTripShortName(String tripShortName) {
        this.tripShortName = tripShortName;
    }

    public String getTripHeadsign() {
        return this.tripHeadsign;
    }

    public void setTripHeadsign(String tripHeadsign) {
        this.tripHeadsign = tripHeadsign;
    }

    public String getDirectionId() {
        return this.directionId;
    }

    public void setDirectionId(String directionId) {
        this.directionId = directionId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public AgencyAndId getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(AgencyAndId shapeId) {
        this.shapeId = shapeId;
    }

    public void setWheelchairAccessible(int wheelchairAccessible) {
        this.wheelchairAccessible = wheelchairAccessible;
    }

    public int getWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    public Double getMeanDurationFactor() {
        return this.meanDurationFactor;
    }

    public void setMeanDurationFactor(Double meanDurationFactor) {
        this.meanDurationFactor = meanDurationFactor;
    }

    public Double getMeanDurationOffset() {
        return this.meanDurationOffset;
    }

    public void setMeanDurationOffset(Double meanDurationOffset) {
        this.meanDurationOffset = meanDurationOffset;
    }

    public Double getSafeDurationFactor() {
        return this.safeDurationFactor;
    }

    public void setSafeDurationFactor(Double safeDurationFactor) {
        this.safeDurationFactor = safeDurationFactor;
    }

    public Double getSafeDurationOffset() {
        return this.safeDurationOffset;
    }

    public void setSafeDurationOffset(Double safeDurationOffset) {
        this.safeDurationOffset = safeDurationOffset;
    }

    public int getBikesAllowed() {
        return this.bikesAllowed;
    }

    public void setBikesAllowed(int bikesAllowed) {
        this.bikesAllowed = bikesAllowed;
    }

    public int getCarsAllowed() {
        return this.carsAllowed;
    }

    public void setCarsAllowed(int carsAllowed) {
        this.carsAllowed = carsAllowed;
    }

    public String toString() {
        return "<Trip " + String.valueOf(this.getId()) + ">";
    }

    public Note getNote() {
        return this.note;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public int getPeakOffpeak() {
        return this.peakOffpeak;
    }

    public void setPeakOffpeak(int peakOffpeak) {
        this.peakOffpeak = peakOffpeak;
    }

    public String getMtaTripId() {
        return this.mtaTripId;
    }

    public void setMtaTripId(String mtaTripId) {
        this.mtaTripId = mtaTripId;
    }

    public int getBoardingType() {
        return this.boardingType;
    }

    public void setBoardingType(int boardingType) {
        this.boardingType = boardingType;
    }
}

