/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.impl.GenericDaoImpl;
import org.onebusaway.gtfs.impl.ShapePointArray;
import org.onebusaway.gtfs.impl.StopTimeArray;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.Block;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.Facility;
import org.onebusaway.gtfs.model.FacilityProperty;
import org.onebusaway.gtfs.model.FacilityPropertyDefinition;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Level;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.LocationGroupElement;
import org.onebusaway.gtfs.model.Network;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.RouteShape;
import org.onebusaway.gtfs.model.RouteStop;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Translation;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.Vehicle;
import org.onebusaway.gtfs.services.GtfsMutableDao;

public class GtfsDaoImpl
extends GenericDaoImpl
implements GtfsMutableDao {
    public static final String[] OPTIONAL_FILE_NAMES = new String[]{"modifications.txt"};
    private final StopTimeArray stopTimes = new StopTimeArray();
    private final ShapePointArray shapePoints = new ShapePointArray();
    private boolean packStopTimes = false;
    private boolean packShapePoints = false;
    private List<String> _optionalMetadataFilenames = null;
    private final Map<String, String> metadataByFilename = new HashMap<String, String>();

    public GtfsDaoImpl() {
        this._optionalMetadataFilenames = new ArrayList<String>();
        if (OPTIONAL_FILE_NAMES != null) {
            Collections.addAll(this._optionalMetadataFilenames, OPTIONAL_FILE_NAMES);
        }
    }

    public boolean isPackStopTimes() {
        return this.packStopTimes;
    }

    public void setPackStopTimes(boolean packStopTimes) {
        this.packStopTimes = packStopTimes;
    }

    public boolean isPackShapePoints() {
        return this.packShapePoints;
    }

    public void setPackShapePoints(boolean packShapePoints) {
        this.packShapePoints = packShapePoints;
    }

    @Override
    public Agency getAgencyForId(String id) {
        return this.getEntityForId(Agency.class, (Serializable)((Object)id));
    }

    @Override
    public Collection<Agency> getAllAgencies() {
        return this.getAllEntitiesForType(Agency.class);
    }

    @Override
    public Collection<Block> getAllBlocks() {
        return this.getAllEntitiesForType(Block.class);
    }

    @Override
    public Collection<ServiceCalendarDate> getAllCalendarDates() {
        return this.getAllEntitiesForType(ServiceCalendarDate.class);
    }

    @Override
    public Collection<ServiceCalendar> getAllCalendars() {
        return this.getAllEntitiesForType(ServiceCalendar.class);
    }

    @Override
    public Collection<FareAttribute> getAllFareAttributes() {
        return this.getAllEntitiesForType(FareAttribute.class);
    }

    @Override
    public Collection<FareRule> getAllFareRules() {
        return this.getAllEntitiesForType(FareRule.class);
    }

    @Override
    public Collection<FeedInfo> getAllFeedInfos() {
        return this.getAllEntitiesForType(FeedInfo.class);
    }

    @Override
    public Collection<Frequency> getAllFrequencies() {
        return this.getAllEntitiesForType(Frequency.class);
    }

    @Override
    public Collection<Route> getAllRoutes() {
        return this.getAllEntitiesForType(Route.class);
    }

    @Override
    public Collection<RouteStop> getAllRouteStops() {
        return this.getAllEntitiesForType(RouteStop.class);
    }

    @Override
    public Collection<RouteShape> getAllRouteShapes() {
        return this.getAllEntitiesForType(RouteShape.class);
    }

    @Override
    public Collection<ShapePoint> getAllShapePoints() {
        if (this.packShapePoints) {
            return this.shapePoints;
        }
        return this.getAllEntitiesForType(ShapePoint.class);
    }

    @Override
    public Collection<StopTime> getAllStopTimes() {
        if (this.packStopTimes) {
            return this.stopTimes;
        }
        return this.getAllEntitiesForType(StopTime.class);
    }

    @Override
    public Collection<Stop> getAllStops() {
        return this.getAllEntitiesForType(Stop.class);
    }

    @Override
    public Collection<Transfer> getAllTransfers() {
        return this.getAllEntitiesForType(Transfer.class);
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this.getAllEntitiesForType(Trip.class);
    }

    @Override
    public Collection<Ridership> getAllRiderships() {
        return this.getAllEntitiesForType(Ridership.class);
    }

    @Override
    public Collection<Vehicle> getAllVehicles() {
        return this.getAllEntitiesForType(Vehicle.class);
    }

    @Override
    public Collection<Level> getAllLevels() {
        return this.getAllEntitiesForType(Level.class);
    }

    @Override
    public Block getBlockForId(int id) {
        return this.getEntityForId(Block.class, Integer.valueOf(id));
    }

    @Override
    public ServiceCalendarDate getCalendarDateForId(int id) {
        return this.getEntityForId(ServiceCalendarDate.class, Integer.valueOf(id));
    }

    @Override
    public ServiceCalendar getCalendarForId(int id) {
        return this.getEntityForId(ServiceCalendar.class, Integer.valueOf(id));
    }

    @Override
    public FareAttribute getFareAttributeForId(AgencyAndId id) {
        return this.getEntityForId(FareAttribute.class, id);
    }

    @Override
    public Collection<FareLegRule> getAllFareLegRules() {
        return this.getAllEntitiesForType(FareLegRule.class);
    }

    @Override
    public Collection<FareProduct> getAllFareProducts() {
        return this.getAllEntitiesForType(FareProduct.class);
    }

    @Override
    public FareProduct getFareProductForId(AgencyAndId id) {
        return this.getEntityForId(FareProduct.class, id);
    }

    @Override
    public Collection<FareMedium> getAllFareMedia() {
        return this.getAllEntitiesForType(FareMedium.class);
    }

    @Override
    public Collection<RiderCategory> getAllRiderCategories() {
        return this.getAllEntitiesForType(RiderCategory.class);
    }

    @Override
    public FareRule getFareRuleForId(int id) {
        return this.getEntityForId(FareRule.class, Integer.valueOf(id));
    }

    @Override
    public Collection<FareTransferRule> getAllFareTransferRules() {
        return this.getAllEntitiesForType(FareTransferRule.class);
    }

    @Override
    public FeedInfo getFeedInfoForId(String id) {
        return this.getEntityForId(FeedInfo.class, (Serializable)((Object)id));
    }

    @Override
    public Frequency getFrequencyForId(int id) {
        return this.getEntityForId(Frequency.class, Integer.valueOf(id));
    }

    @Override
    public Collection<Pathway> getAllPathways() {
        return this.getAllEntitiesForType(Pathway.class);
    }

    @Override
    public Pathway getPathwayForId(AgencyAndId id) {
        return this.getEntityForId(Pathway.class, id);
    }

    @Override
    public Route getRouteForId(AgencyAndId id) {
        return this.getEntityForId(Route.class, id);
    }

    @Override
    public ShapePoint getShapePointForId(int id) {
        if (this.packShapePoints) {
            return this.shapePoints.get(id);
        }
        return this.getEntityForId(ShapePoint.class, Integer.valueOf(id));
    }

    @Override
    public Stop getStopForId(AgencyAndId id) {
        return this.getEntityForId(Stop.class, id);
    }

    @Override
    public StopTime getStopTimeForId(int id) {
        if (this.packStopTimes) {
            return this.stopTimes.get(id);
        }
        return this.getEntityForId(StopTime.class, Integer.valueOf(id));
    }

    @Override
    public Transfer getTransferForId(int id) {
        return this.getEntityForId(Transfer.class, Integer.valueOf(id));
    }

    @Override
    public Trip getTripForId(AgencyAndId id) {
        return this.getEntityForId(Trip.class, id);
    }

    @Override
    public Level getLevelForId(AgencyAndId id) {
        return this.getEntityForId(Level.class, id);
    }

    @Override
    public Vehicle getVehicleForId(AgencyAndId id) {
        return this.getEntityForId(Vehicle.class, id);
    }

    @Override
    public Collection<Network> getAllNetworks() {
        return this.getAllEntitiesForType(Network.class);
    }

    public Facility getFacilityForId(AgencyAndId id) {
        return this.getEntityForId(Facility.class, id);
    }

    public FacilityProperty getFacilityPropertiesForId(AgencyAndId id) {
        return this.getEntityForId(FacilityProperty.class, id);
    }

    public FacilityPropertyDefinition getFacilityPropertiesDefinitionsForId(AgencyAndId id) {
        return this.getEntityForId(FacilityPropertyDefinition.class, id);
    }

    @Override
    public Collection<DirectionEntry> getAllDirectionEntries() {
        return this.getAllEntitiesForType(DirectionEntry.class);
    }

    public Collection<Facility> getAllFacilities() {
        return this.getAllEntitiesForType(Facility.class);
    }

    public Collection<FacilityProperty> getAllFacilityProperties() {
        return this.getAllEntitiesForType(FacilityProperty.class);
    }

    public Collection<FacilityPropertyDefinition> getAllFacilityPropertyDefinitions() {
        return this.getAllEntitiesForType(FacilityPropertyDefinition.class);
    }

    @Override
    public Collection<Area> getAllAreas() {
        return this.getAllEntitiesForType(Area.class);
    }

    @Override
    public Collection<LocationGroupElement> getAllLocationGroupElements() {
        return this.getAllEntitiesForType(LocationGroupElement.class);
    }

    @Override
    public Collection<LocationGroup> getAllLocationGroups() {
        return this.getAllEntitiesForType(LocationGroup.class);
    }

    @Override
    public Collection<StopAreaElement> getAllStopAreaElements() {
        return this.getAllEntitiesForType(StopAreaElement.class);
    }

    @Override
    public Collection<Location> getAllLocations() {
        return this.getAllEntitiesForType(Location.class);
    }

    @Override
    public Collection<BookingRule> getAllBookingRules() {
        return this.getAllEntitiesForType(BookingRule.class);
    }

    @Override
    public Collection<Translation> getAllTranslations() {
        return this.getAllEntitiesForType(Translation.class);
    }

    @Override
    public <K, V> Map<K, V> getEntitiesByIdForEntityType(Class<K> keyType, Class<V> entityType) {
        this.noKeyCheck(keyType);
        return super.getEntitiesByIdForEntityType(keyType, entityType);
    }

    @Override
    public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            return this.stopTimes;
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            return this.shapePoints;
        }
        return super.getAllEntitiesForType(type);
    }

    @Override
    public <T> T getEntityForId(Class<T> type, Serializable id) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            return (T)this.stopTimes.get((Integer)id);
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            return (T)this.shapePoints.get((Integer)id);
        }
        return super.getEntityForId(type, id);
    }

    @Override
    public void saveEntity(Object entity) {
        if (this.packStopTimes && entity.getClass().equals(StopTime.class)) {
            this.stopTimes.add((StopTime)entity);
            return;
        }
        if (this.packShapePoints && entity.getClass().equals(ShapePoint.class)) {
            this.shapePoints.add((ShapePoint)entity);
            return;
        }
        super.saveEntity(entity);
    }

    @Override
    public <T> void clearAllEntitiesForType(Class<T> type) {
        if (this.packStopTimes && type.equals(StopTime.class)) {
            this.stopTimes.clear();
            return;
        }
        if (this.packShapePoints && type.equals(ShapePoint.class)) {
            this.shapePoints.clear();
            return;
        }
        super.clearAllEntitiesForType(type);
    }

    @Override
    public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
        if (this.packStopTimes && entity.getClass().equals(StopTime.class)) {
            throw new UnsupportedOperationException();
        }
        if (this.packShapePoints && entity.getClass().equals(ShapePoint.class)) {
            throw new UnsupportedOperationException();
        }
        super.removeEntity(entity);
    }

    @Override
    public void close() {
        if (this.packStopTimes) {
            this.stopTimes.trimToSize();
        }
        if (this.packShapePoints) {
            this.shapePoints.trimToSize();
        }
        super.close();
    }

    @Override
    public List<String> getOptionalMetadataFilenames() {
        return this._optionalMetadataFilenames;
    }

    @Override
    public boolean hasMetadata(String filename) {
        return this.metadataByFilename.containsKey(filename);
    }

    @Override
    public String getMetadata(String filename) {
        return this.metadataByFilename.get(filename);
    }

    @Override
    public void addMetadata(String filename, String content) {
        this.metadataByFilename.put(filename, content);
        if (!this._optionalMetadataFilenames.contains(filename)) {
            this._optionalMetadataFilenames.add(filename);
        }
    }

    private <K> void noKeyCheck(Class<K> keyType) {
        if (this.packStopTimes && keyType.equals(StopTime.class)) {
            throw new UnsupportedOperationException();
        }
        if (this.packShapePoints && keyType.equals(ShapePoint.class)) {
            throw new UnsupportedOperationException();
        }
    }
}

