/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.ConverterFactory;

class EntityFieldMappingImpl
extends AbstractFieldMapping
implements ConverterFactory {
    private Class<?> _objFieldType;

    public EntityFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        super(entityType, csvFieldName, objFieldName, required);
        this._objFieldType = objFieldType;
    }

    public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
        if (this.isMissingAndOptional(csvValues)) {
            return;
        }
        Converter converter = this.create(context);
        String entityId = (String)csvValues.get(this._csvFieldName);
        Object entity = converter.convert(this._objFieldType, (Object)entityId);
        object.setPropertyValue(this._objFieldName, entity);
    }

    public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
        IdentityBean entity = (IdentityBean)object.getPropertyValue(this._objFieldName);
        if (this.isOptional() && entity == null) {
            return;
        }
        AgencyAndId id = (AgencyAndId)entity.getId();
        csvValues.put(this._csvFieldName, id.getId());
    }

    @Override
    public Converter create(CsvEntityContext context) {
        GtfsReaderContext ctx = (GtfsReaderContext)context.get((Object)GtfsReader.KEY_CONTEXT);
        return new ConverterImpl(ctx);
    }

    private class ConverterImpl
    implements Converter {
        private GtfsReaderContext _context;

        public ConverterImpl(GtfsReaderContext context) {
            this._context = context;
        }

        public Object convert(Class type, Object value) {
            if (type == String.class) {
                if (value instanceof String) {
                    return (String)value;
                }
            } else if (type == EntityFieldMappingImpl.this._objFieldType) {
                String entityId = value.toString();
                String agencyId = this._context.getAgencyForEntity(EntityFieldMappingImpl.this._objFieldType, entityId);
                AgencyAndId id = new AgencyAndId(agencyId, entityId);
                return this._context.getEntity(EntityFieldMappingImpl.this._objFieldType, id);
            }
            throw new ConversionException("Could not convert " + String.valueOf(value) + " of type " + String.valueOf(value.getClass()) + " to " + String.valueOf(type));
        }
    }
}

