/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.presentation.client.RoutePresenter;
import org.onebusaway.presentation.impl.AgencyPresenter;
import org.onebusaway.presentation.services.DefaultSearchLocationService;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.users.client.model.UserBean;
import org.onebusaway.users.services.CurrentUserService;
import org.onebusaway.util.SystemTime;
import org.onebusaway.utility.text.NaturalStringOrder;
import org.onebusaway.utility.text.StringLibrary;
import org.springframework.beans.factory.annotation.Autowired;

public class ArrivalsAndDeparturesModel {
    private static final OrderConstraint SORT_BY_TIME = new SortByTime();
    private static final OrderConstraint SORT_BY_DEST = new SortByDestination();
    private static final OrderConstraint SORT_BY_ROUTE = new SortByRoute();
    private TransitDataService _transitDataService;
    private CurrentUserService _currentUserService;
    private DefaultSearchLocationService _defaultSearchLocationService;
    private List<String> _stopIds;
    private Set<String> _routeFilter = new HashSet<String>();
    private OrderConstraint _order = SORT_BY_TIME;
    private TimeZone _timeZone;
    private ArrivalsAndDeparturesQueryBean _query = new ArrivalsAndDeparturesQueryBean();
    protected StopsWithArrivalsAndDeparturesBean _result;
    private List<AgencyBean> _agencies;
    private boolean _filtered = false;
    protected UserBean _user;
    private boolean _onlyNext = false;
    private boolean _showArrivals = false;
    private int _refresh = 60;

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Autowired
    public void setCurrentUserService(CurrentUserService currentUserService) {
        this._currentUserService = currentUserService;
    }

    @Autowired
    public void setDefaultSearchLocationService(DefaultSearchLocationService defaultSearchLocationService) {
        this._defaultSearchLocationService = defaultSearchLocationService;
    }

    public void setStopIds(List<String> stopIds) {
        this._stopIds = stopIds;
    }

    public List<String> getStopIds() {
        return this._stopIds;
    }

    public void setRouteFilter(Set<String> routeFilter) {
        this._routeFilter = routeFilter;
    }

    public Set<String> getRouteFilter() {
        return this._routeFilter;
    }

    public boolean setOrderFromString(String order) {
        if ("route".equals(order)) {
            this._order = SORT_BY_ROUTE;
        } else if ("dest".equals(order)) {
            this._order = SORT_BY_DEST;
        } else if ("time".equals(order)) {
            this._order = SORT_BY_TIME;
        } else {
            return false;
        }
        return true;
    }

    public void setTargetTime(Date time) {
        this._query.setTime(time.getTime());
    }

    public void setMinutesBefore(int minutesBefore) {
        this._query.setMinutesBefore(minutesBefore);
    }

    public void setMinutesAfter(int minutesAfter) {
        this._query.setMinutesAfter(minutesAfter);
    }

    public void setFrequencyMinutesBefore(int frequencyMinutesBefore) {
        this._query.setFrequencyMinutesBefore(frequencyMinutesBefore);
    }

    public void setFrequencyMinutesAfter(int frequencyMinutesAfter) {
        this._query.setFrequencyMinutesAfter(frequencyMinutesAfter);
    }

    public void setOnlyNext(boolean onlyNext) {
        this._onlyNext = onlyNext;
    }

    public void setShowArrivals(boolean showArrivals) {
        this._showArrivals = showArrivals;
    }

    public void setRefresh(int refresh) {
        this._refresh = refresh;
    }

    public int getRefresh() {
        return this._refresh;
    }

    public boolean isMissingData() {
        return this._stopIds == null || this._stopIds.isEmpty();
    }

    public void process() {
        this._result = this._transitDataService.getStopsWithArrivalsAndDepartures(this._stopIds, this._query, new AgencyServiceInterval(SystemTime.currentTimeMillis()));
        this.checkForEmptyResult();
        this.filterResults();
        this.orderResults();
        this._agencies = AgencyPresenter.getAgenciesForArrivalAndDepartures(this._result.getArrivalsAndDepartures());
        this._timeZone = TimeZone.getTimeZone(this._result.getTimeZone());
        if (this._timeZone == null) {
            this._timeZone = TimeZone.getDefault();
        }
        this.updateCurrentUser();
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public StopsWithArrivalsAndDeparturesBean getResult() {
        return this._result;
    }

    public void setResult(StopsWithArrivalsAndDeparturesBean result) {
        this._result = result;
    }

    public boolean isFiltered() {
        return this._filtered;
    }

    public List<AgencyBean> getAgencies() {
        return this._agencies;
    }

    private void checkForEmptyResult() {
        if (this._result == null) {
            if (this._stopIds.size() == 1) {
                throw new NoSuchStopServiceException(this._stopIds.get(0));
            }
            throw new NoSuchStopServiceException(this._stopIds.toString());
        }
    }

    private void filterResults() {
        this.applyRouteFilter();
        this.applyArrivalsVsDeparturesFilter();
        this.applyOnlyNextFilter();
    }

    public void applyDedupe() {
        if (this._result.getArrivalsAndDepartures() == null || this._result.getArrivalsAndDepartures().size() < 2) {
            return;
        }
        HashSet<String> found = new HashSet<String>();
        ArrayList<ArrivalAndDepartureBean> arrivalsAndDepartures = new ArrayList<ArrivalAndDepartureBean>();
        for (ArrivalAndDepartureBean ad : this._result.getArrivalsAndDepartures()) {
            if (found.contains(ad.toString())) continue;
            found.add(ad.toString());
            arrivalsAndDepartures.add(ad);
        }
        this._result.setArrivalsAndDepartures(arrivalsAndDepartures);
    }

    private void applyRouteFilter() {
        if (this._routeFilter == null || this._routeFilter.isEmpty()) {
            return;
        }
        ArrayList<ArrivalAndDepartureBean> filtered = new ArrayList<ArrivalAndDepartureBean>();
        for (ArrivalAndDepartureBean bean : this._result.getArrivalsAndDepartures()) {
            if (this._routeFilter.contains(bean.getTrip().getRoute().getId())) {
                filtered.add(bean);
                continue;
            }
            this._filtered = true;
        }
        this._result.setArrivalsAndDepartures(filtered);
    }

    private void applyArrivalsVsDeparturesFilter() {
        ArrayList<ArrivalAndDepartureBean> filtered = new ArrayList<ArrivalAndDepartureBean>();
        for (ArrivalAndDepartureBean bean : this._result.getArrivalsAndDepartures()) {
            if ((!this._showArrivals || !bean.isArrivalEnabled()) && (this._showArrivals || !bean.isDepartureEnabled())) continue;
            filtered.add(bean);
        }
        this._result.setArrivalsAndDepartures(filtered);
    }

    private void applyOnlyNextFilter() {
        if (!this._onlyNext) {
            return;
        }
        List current = this._result.getArrivalsAndDepartures();
        Collections.sort(current, SORT_BY_TIME);
        HashMap<String, ArrivalAndDepartureBean> keepers = new HashMap<String, ArrivalAndDepartureBean>();
        for (ArrivalAndDepartureBean bean : current) {
            String key = this.getRouteKeyForArrivalAndDeparture(bean);
            if (keepers.containsKey(key)) continue;
            keepers.put(key, bean);
        }
        ArrayList filtered = new ArrayList(keepers.values());
        OrderConstraint c = this._order == null ? SORT_BY_TIME : this._order;
        Collections.sort(filtered, c);
        this._result.setArrivalsAndDepartures(filtered);
    }

    private String getRouteKeyForArrivalAndDeparture(ArrivalAndDepartureBean bean) {
        String name = bean.getRouteShortName();
        if (name != null) {
            return name;
        }
        TripBean trip = bean.getTrip();
        name = trip.getRouteShortName();
        if (name != null) {
            return name;
        }
        RouteBean route = trip.getRoute();
        name = route.getShortName();
        if (name != null) {
            return name;
        }
        return route.getId();
    }

    private void orderResults() {
        if (this._order != null) {
            Collections.sort(this._result.getArrivalsAndDepartures(), this._order);
        }
    }

    private void updateCurrentUser() {
        this._currentUserService.setLastSelectedStopIds(this._stopIds);
        this._user = this._currentUserService.getCurrentUser();
        if (this._user == null || !this._user.hasDefaultLocation()) {
            List stops = this._result.getStops();
            StopBean stop = (StopBean)stops.get(0);
            this._defaultSearchLocationService.setDefaultLocationForCurrentUser(stop.getName(), stop.getLat(), stop.getLon());
        }
    }

    private static class SortByDestination
    implements OrderConstraint {
        private SortByDestination() {
        }

        @Override
        public int compare(ArrivalAndDepartureBean o1, ArrivalAndDepartureBean o2) {
            String a = StringLibrary.getBestName((String[])new String[]{o1.getTripHeadsign(), o1.getTrip().getTripHeadsign(), ""});
            String b = StringLibrary.getBestName((String[])new String[]{o2.getTripHeadsign(), o2.getTrip().getTripHeadsign(), ""});
            int i = a.compareTo(b);
            if (i == 0) {
                return SORT_BY_TIME.compare(o1, o2);
            }
            return i;
        }
    }

    private static class SortByTime
    implements OrderConstraint {
        private SortByTime() {
        }

        @Override
        public int compare(ArrivalAndDepartureBean o1, ArrivalAndDepartureBean o2) {
            long b;
            long a = o1.computeBestDepartureTime();
            return a == (b = o2.computeBestDepartureTime()) ? 0 : (a < b ? -1 : 1);
        }
    }

    private static class SortByRoute
    implements OrderConstraint {
        private SortByRoute() {
        }

        @Override
        public int compare(ArrivalAndDepartureBean o1, ArrivalAndDepartureBean o2) {
            String b;
            String a = RoutePresenter.getNameForRoute(o1.getTrip().getRoute());
            if (a.equals(b = RoutePresenter.getNameForRoute(o2.getTrip().getRoute()))) {
                return SORT_BY_TIME.compare(o1, o2);
            }
            return NaturalStringOrder.compareNaturalIgnoreCaseAscii((String)a, (String)b);
        }
    }

    private static interface OrderConstraint
    extends Comparator<ArrivalAndDepartureBean> {
    }
}

