/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopyCompiledGwtResourcesMain {
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: webapp-target-dir");
            System.exit(-1);
        }
        File pomFile = new File("pom.xml");
        File webappDirectory = new File(args[0]);
        if (!pomFile.exists()) {
            System.err.println("ERROR - didn't find the pom file where we expected it: " + pomFile.getAbsolutePath());
            System.exit(-1);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        Document doc = builder.parse(pomFile);
        String expression = "project/build/plugins/plugin[artifactId='maven-war-plugin']/configuration/webResources/resource";
        NodeList nodes = CopyCompiledGwtResourcesMain.xpath(doc, expression, NodeList.class);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node resourceNode = nodes.item(i);
            Node directoryNode = CopyCompiledGwtResourcesMain.xpath(resourceNode, "directory", Node.class);
            Node targetPathNode = CopyCompiledGwtResourcesMain.xpath(resourceNode, "targetPath", Node.class);
            String directory = directoryNode.getTextContent();
            String targetPath = targetPathNode.getTextContent();
            directory = CopyCompiledGwtResourcesMain.resolveValue(directory);
            System.out.println("directory=" + directory);
            System.out.println("targetPath=" + targetPath);
            CopyCompiledGwtResourcesMain.copyFiles(new File(directory), new File(webappDirectory, targetPath));
        }
    }

    private static String resolveValue(String value) {
        Matcher m = _pattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String property = m.group(1);
            String propertyValue = System.getProperty(property);
            propertyValue = propertyValue == null && property.equals("project.build.directory") ? "target" : CopyCompiledGwtResourcesMain.resolveValue(propertyValue);
            m.appendReplacement(sb, propertyValue);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static void copyFiles(File sourceDirectory, File targetDirectory) throws IOException {
        File[] files;
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return;
        }
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        if ((files = sourceDirectory.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            File targetFile = new File(targetDirectory, file.getName());
            if (targetFile.exists() && file.lastModified() <= targetFile.lastModified()) continue;
            if (file.isDirectory()) {
                CopyCompiledGwtResourcesMain.copyFiles(file, targetFile);
                continue;
            }
            CopyCompiledGwtResourcesMain.copyFile(file, targetFile);
        }
    }

    private static void copyFile(File srcFile, File dstFile) throws IOException {
        int rc;
        System.out.println("from=" + srcFile.getAbsolutePath());
        System.out.println("to=" + dstFile.getAbsolutePath());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFile));
        byte[] buffer = new byte[1024];
        while ((rc = ((InputStream)in).read(buffer)) != -1) {
            if (rc <= 0) continue;
            ((OutputStream)out).write(buffer, 0, rc);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static <T> T xpath(Node node, String expression, Class<T> type) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile(expression);
        QName returnType = null;
        if (type == NodeList.class) {
            returnType = XPathConstants.NODESET;
        } else if (type == Node.class) {
            returnType = XPathConstants.NODE;
        } else {
            throw new IllegalStateException("unknown return type " + type);
        }
        return (T)expr.evaluate(node, returnType);
    }
}

