/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.interceptor.SessionAware;
import org.onebusaway.presentation.model.NextAction;

public abstract class NextActionSupport
extends ActionSupport
implements SessionAware {
    private static final long serialVersionUID = 1L;
    private static final String NEXT_ACTION_STACK_SESSION_KEY = NextActionSupport.class.getName() + ".nextActionStack";
    protected Map<String, Object> _session;

    public void setSession(Map<String, Object> session) {
        this._session = session;
    }

    protected void clearNextActions() {
        List<NextAction> stack = this.getNextActionStack(false);
        if (stack != null) {
            stack.clear();
        }
        stack = this.getNextActionStack(false);
    }

    protected String getNextActionOrSuccess() {
        List<NextAction> stack = this.getNextActionStack(false);
        if (stack == null || stack.isEmpty()) {
            return "success";
        }
        NextAction next = stack.remove(stack.size() - 1);
        Map<String, String[]> params = next.getParameters();
        if (params != null && !params.isEmpty()) {
            ActionContext context = ActionContext.getContext();
            HttpParameters parameters = context.getParameters();
            HashMap<String, String> contextParameters = new HashMap<String, String>();
            for (String key : parameters.keySet()) {
                contextParameters.put(key, parameters.get((Object)key).getValue());
            }
        }
        return next.getAction();
    }

    protected void pushNextAction(String action) {
        List<NextAction> stack = this.getNextActionStack(true);
        stack.add(new NextAction(action));
    }

    protected void pushNextAction(String action, String key, String value) {
        List<NextAction> stack = this.getNextActionStack(true);
        stack.add(new NextAction(action, key, value));
    }

    private List<NextAction> getNextActionStack(boolean create) {
        ArrayList stack = (ArrayList)this._session.get(NEXT_ACTION_STACK_SESSION_KEY);
        if (stack == null && create) {
            stack = new ArrayList();
            this._session.put(NEXT_ACTION_STACK_SESSION_KEY, stack);
        }
        return stack;
    }
}

