/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String _target;
    private String _source;

    public void init(ServletConfig config) throws ServletException {
        this._target = config.getInitParameter("target");
        if (this._target == null) {
            throw new ServletException("you did not specify a target parameter");
        }
        this._source = config.getInitParameter("source");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        GetMethod method = new GetMethod(this.proxyUrl(req));
        this.executeMethod((HttpMethod)method, resp);
    }

    private String proxyUrl(HttpServletRequest req) {
        String pathInfo = req.getRequestURI();
        if (this._source != null) {
            pathInfo = pathInfo.replaceFirst(this._source, "");
        }
        String url = this._target + pathInfo;
        if (!this._target.startsWith("http")) {
            url = "http://" + req.getLocalName() + ":" + req.getLocalPort() + url;
        }
        if (req.getQueryString() != null) {
            url = url + "?" + req.getQueryString();
        }
        return url;
    }

    private void executeMethod(HttpMethod method, HttpServletResponse resp) throws ServletException, IOException {
        int rc;
        Header[] headerArrayResponse;
        HttpClient client = new HttpClient();
        int status = client.executeMethod(method);
        resp.setStatus(status);
        for (Header header : headerArrayResponse = method.getResponseHeaders()) {
            resp.setHeader(header.getName(), header.getValue());
        }
        InputStream in = method.getResponseBodyAsStream();
        ServletOutputStream out = resp.getOutputStream();
        byte[] buffer = new byte[1024];
        while ((rc = in.read(buffer)) != -1) {
            out.write(buffer, 0, rc);
        }
    }
}

