/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.exceptions.InvalidSelectionServiceException;
import org.onebusaway.presentation.model.StopSelectionBean;
import org.onebusaway.presentation.model.StopSelectionTreeBean;
import org.onebusaway.presentation.services.LocationNameSplitStrategy;
import org.onebusaway.presentation.services.StopSelectionService;
import org.onebusaway.transit_data.model.NameBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.springframework.stereotype.Component;

@Component
class StopSelectionServiceImpl
implements StopSelectionService {
    private boolean _splitStopNames = false;
    private LocationNameSplitStrategy _locationNameSplitStrategy;

    StopSelectionServiceImpl() {
    }

    public void setLocationNameSplitStrategy(LocationNameSplitStrategy locationNameSplitStrategy) {
        this._locationNameSplitStrategy = locationNameSplitStrategy;
    }

    @Override
    public StopSelectionBean getSelectedStops(StopsForRouteBean stopsForRoute, List<Integer> selectionIndices) throws InvalidSelectionServiceException {
        StopSelectionBean selection = new StopSelectionBean();
        StopSelectionTreeBean tree = this.getStopsForRouteAsStopSelectionTree(stopsForRoute);
        this.visitTree(tree, selection, selectionIndices, 0);
        return selection;
    }

    private StopSelectionTreeBean getStopsForRouteAsStopSelectionTree(StopsForRouteBean stopsForRoute) {
        StopSelectionTreeBean tree = new StopSelectionTreeBean();
        StopGroupingBean byDirection = this.getGroupingByType(stopsForRoute, "direction");
        Map<String, StopBean> stopsById = this.getStopsById(stopsForRoute);
        if (byDirection != null) {
            this.groupByDirection(tree, stopsForRoute, byDirection, stopsById);
        } else {
            this.groupByStop(tree, stopsForRoute.getStops());
        }
        return tree;
    }

    private StopGroupingBean getGroupingByType(StopsForRouteBean stopsForRoute, String type) {
        List groupings = stopsForRoute.getStopGroupings();
        for (StopGroupingBean grouping : groupings) {
            if (!grouping.getType().equals(type)) continue;
            return grouping;
        }
        return null;
    }

    private void groupByDirection(StopSelectionTreeBean tree, StopsForRouteBean stopsForRoute, StopGroupingBean byDirection, Map<String, StopBean> stopsById) {
        List groups = byDirection.getStopGroups();
        if (groups.isEmpty()) {
            this.groupByStop(tree, stopsForRoute.getStops());
            return;
        }
        for (StopGroupBean group : groups) {
            StopSelectionTreeBean subTree = tree.getSubTree(group.getName());
            ArrayList<StopBean> stops = new ArrayList<StopBean>();
            for (String stopId : group.getStopIds()) {
                stops.add(stopsById.get(stopId));
            }
            this.groupByStop(subTree, stops);
        }
    }

    private void groupByStop(StopSelectionTreeBean tree, Iterable<StopBean> stops) {
        for (StopBean stop : stops) {
            StopSelectionTreeBean subTree = tree;
            if (this._splitStopNames) {
                List<NameBean> names = this._locationNameSplitStrategy.splitLocationNameIntoParts(stop.getName());
                for (NameBean name : names) {
                    subTree = subTree.getSubTree(name);
                }
            } else {
                NameBean name = new NameBean("stop_name", new String[]{stop.getName()});
                subTree = subTree.getSubTree(name);
            }
            String code = stop.getCode() != null ? stop.getCode() : stop.getId();
            NameBean name = new NameBean("description", new String[]{"Stop # " + code});
            subTree = subTree.getSubTree(name);
            subTree.setStop(stop);
        }
    }

    private Map<String, StopBean> getStopsById(StopsForRouteBean stopsForRoute) {
        HashMap<String, StopBean> stopsById = new HashMap<String, StopBean>();
        for (StopBean stop : stopsForRoute.getStops()) {
            stopsById.put(stop.getId(), stop);
        }
        return stopsById;
    }

    private void visitTree(StopSelectionTreeBean tree, StopSelectionBean selection, List<Integer> selectionIndices, int index) throws InvalidSelectionServiceException {
        if (tree.hasStop()) {
            selection.setStop(tree.getStop());
            return;
        }
        Set<NameBean> names = tree.getNames();
        if (names.size() == 1) {
            NameBean next = names.iterator().next();
            selection.addSelected(next);
            StopSelectionTreeBean stopSelectionTreeBean = tree.getSubTree(next);
            this.visitTree(stopSelectionTreeBean, selection, selectionIndices, index);
            return;
        }
        if (index >= selectionIndices.size()) {
            for (NameBean nameBean : names) {
                StopBean stop = this.getStop(tree.getSubTree(nameBean));
                if (stop != null) {
                    selection.addNameWithStop(nameBean, stop);
                    continue;
                }
                selection.addName(nameBean);
            }
            List<StopBean> stops = tree.getAllStops();
            for (StopBean stop : stops) {
                selection.addStop(stop);
            }
            return;
        }
        int i = 0;
        int n = selectionIndices.get(index);
        for (NameBean name : names) {
            if (n == i) {
                selection.addSelected(name);
                tree = tree.getSubTree(name);
                this.visitTree(tree, selection, selectionIndices, index + 1);
                return;
            }
            ++i;
        }
        throw new InvalidSelectionServiceException();
    }

    private StopBean getStop(StopSelectionTreeBean tree) {
        if (tree.hasStop()) {
            return tree.getStop();
        }
        if (tree.getNames().size() == 1) {
            NameBean next = tree.getNames().iterator().next();
            return this.getStop(tree.getSubTree(next));
        }
        return null;
    }
}

