/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.realtime;

import javax.annotation.PostConstruct;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.presentation.services.realtime.PresentationService;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data_federation.siri.SiriDistanceExtension;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PresentationServiceImpl
implements PresentationService {
    private static Logger _log = LoggerFactory.getLogger(PresentationServiceImpl.class);
    private static final String APPROACHING_TEXT = "approaching";
    private static final String ONE_STOP_WORD = "stop";
    private static final String MULTIPLE_STOPS_WORD = "stops";
    private static final String ONE_MILE_WORD = "mile";
    private static final String MULTIPLE_MILES_WORD = "miles";
    private static final String AWAY_WORD = "away";
    @Autowired
    private ConfigurationService _configService;
    private boolean _showArrivals = false;
    private Long _now = null;
    private int _atStopThresholdInFeet = 100;
    private int _approachingThresholdInFeet = 500;
    private int _distanceAsStopsThresholdInFeet = 2640;
    private int _distanceAsStopsThresholdInStops = 3;
    private int _distanceAsStopsMaximumThresholdInFeet = 2640;
    private int _expiredTimeout = 300;
    private float _previousTripFilterDistanceMiles = 5.0f;
    private boolean _includeRequiresPhase = false;
    boolean firstLoad;

    @ConfigurationParameter
    public void setAtStopThresholdInFeet(int atStopThresholdInFeet) {
        this._atStopThresholdInFeet = atStopThresholdInFeet;
    }

    @ConfigurationParameter
    public void setApproachingThresholdInFeet(int approachingThresholdInFeet) {
        this._approachingThresholdInFeet = approachingThresholdInFeet;
    }

    @ConfigurationParameter
    public void setDistanceAsStopsThresholdInFeet(int distanceAsStopsThresholdInFeet) {
        this._distanceAsStopsThresholdInFeet = distanceAsStopsThresholdInFeet;
    }

    @ConfigurationParameter
    public void setDistanceAsStopsThresholdInStops(int distanceAsStopsThresholdInStops) {
        this._distanceAsStopsThresholdInStops = distanceAsStopsThresholdInStops;
    }

    @ConfigurationParameter
    public void setDistanceAsStopsMaximumThresholdInFeet(int distanceAsStopsMaximumThresholdInFeet) {
        this._distanceAsStopsMaximumThresholdInFeet = distanceAsStopsMaximumThresholdInFeet;
    }

    @ConfigurationParameter
    public void setExpiredTimeout(int expiredTimeout) {
        this._expiredTimeout = expiredTimeout;
    }

    @ConfigurationParameter
    public void setPreviousTripFilterDistanceMiles(float previousTripFilterDistanceMiles) {
        this._previousTripFilterDistanceMiles = previousTripFilterDistanceMiles;
    }

    @ConfigurationParameter
    public void setIncludeRequiresPhase(boolean needsPhase) {
        this._includeRequiresPhase = needsPhase;
    }

    @Override
    public void setTime(long time) {
        this._now = time;
    }

    public long getTime() {
        if (this._now != null) {
            return this._now;
        }
        return SystemTime.currentTimeMillis();
    }

    @PostConstruct
    public void start() {
        this.firstLoad = true;
    }

    @Override
    public Boolean isInLayover(TripStatusBean statusBean) {
        if (statusBean != null) {
            String phase = statusBean.getPhase();
            if (phase != null && (phase.toUpperCase().equals("LAYOVER_DURING") || phase.toUpperCase().equals("LAYOVER_BEFORE"))) {
                return true;
            }
            return false;
        }
        return null;
    }

    @Override
    public Boolean isBlockLevelInference(TripStatusBean statusBean) {
        if (statusBean != null) {
            String status = statusBean.getStatus();
            if (status != null) {
                return status.contains("blockInf");
            }
            return false;
        }
        return null;
    }

    @Override
    public Boolean isOnDetour(TripStatusBean statusBean) {
        if (statusBean != null) {
            String status = statusBean.getStatus();
            if (status != null) {
                return status.contains("deviated");
            }
            return false;
        }
        return null;
    }

    @Override
    public String getPresentableDistance(SiriDistanceExtension distances) {
        return this.getPresentableDistance(distances, APPROACHING_TEXT, ONE_STOP_WORD, MULTIPLE_STOPS_WORD, ONE_MILE_WORD, MULTIPLE_MILES_WORD, AWAY_WORD);
    }

    @Override
    public String getPresentableDistance(Double distanceFromStop, Integer numberOfStopsAway) {
        return this.getPresentableDistance(distanceFromStop, numberOfStopsAway, APPROACHING_TEXT, ONE_STOP_WORD, MULTIPLE_STOPS_WORD, ONE_MILE_WORD, MULTIPLE_MILES_WORD, AWAY_WORD);
    }

    @Override
    public String getPresentableDistance(SiriDistanceExtension distances, String approachingText, String oneStopWord, String multipleStopsWord, String oneMileWord, String multipleMilesWord, String awayWord) {
        Double distanceFromStop = distances.getDistanceFromCall();
        Integer numberOfStopsAway = distances.getStopsFromCall();
        return this.getPresentableDistance(distanceFromStop, numberOfStopsAway, approachingText, oneStopWord, multipleStopsWord, oneMileWord, multipleMilesWord, awayWord);
    }

    @Override
    public String getPresentableDistance(Double distanceFromStop, Integer numberOfStopsAway, String approachingText, String oneStopWord, String multipleStopsWord, String oneMileWord, String multipleMilesWord, String awayWord) {
        Object r = "";
        double feetAway = distanceFromStop * 3.2808399;
        if (feetAway < (double)this._atStopThresholdInFeet) {
            r = "at " + oneStopWord;
        } else if (feetAway < (double)this._approachingThresholdInFeet) {
            r = approachingText;
        } else if (feetAway <= (double)this._distanceAsStopsMaximumThresholdInFeet && (numberOfStopsAway <= this._distanceAsStopsThresholdInStops || feetAway <= (double)this._distanceAsStopsThresholdInFeet)) {
            r = numberOfStopsAway == 0 ? "< 1 " + oneStopWord + " " + awayWord : (numberOfStopsAway == 1 ? "1 " + oneStopWord + " " + awayWord : numberOfStopsAway + " " + multipleStopsWord + " " + awayWord);
        } else {
            double milesAway = (float)feetAway / 5280.0f;
            r = String.format("%1.1f " + multipleMilesWord + " " + awayWord, milesAway);
        }
        return r;
    }

    @Override
    public boolean include(TripStatusBean statusBean) {
        AgencyAndId agencyFromTrip;
        boolean hideScheduleInfo;
        if (statusBean == null) {
            return false;
        }
        if (statusBean.isPredicted()) {
            _log.debug(statusBean.getVehicleId() + " running through filter: ");
            if (statusBean.getVehicleId() == null) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because vehicle id is null.");
                return false;
            }
            if (Double.isNaN(statusBean.getDistanceAlongTrip())) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because D.A.T. is NaN.");
                return false;
            }
            if (this._includeRequiresPhase && statusBean.getPhase() == null) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because phase is null.");
                return false;
            }
            if (this.isOnDetour(statusBean).booleanValue()) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because of detour.");
                return false;
            }
            String phase = statusBean.getPhase();
            if (!(phase == null || phase.toUpperCase().equals("IN_PROGRESS") || phase.toUpperCase().equals("LAYOVER_BEFORE") || phase.toUpperCase().equals("LAYOVER_DURING"))) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because phase is not in progress.");
                return false;
            }
            String status = statusBean.getStatus();
            if (status != null && status.toUpperCase().equals("DISABLED")) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because it is disabled.");
                return false;
            }
            if (this.getTime() - statusBean.getLastUpdateTime() >= (long)(1000 * this._expiredTimeout)) {
                _log.debug("  " + statusBean.getVehicleId() + " filtered out because data is expired.");
                return false;
            }
        }
        if (!statusBean.isPredicted() && (hideScheduleInfo = this._configService.getConfigurationFlagForAgency((agencyFromTrip = AgencyAndIdLibrary.convertFromString((String)statusBean.getActiveTrip().getId())).getAgencyId(), "hideScheduleInfo"))) {
            return false;
        }
        _log.debug("include passed for " + statusBean.getVehicleId());
        return true;
    }

    @Override
    public boolean include(ArrivalAndDepartureBean adBean, TripStatusBean status) {
        double ratio;
        double totalDistanceAlongTrip;
        double distanceAlongTrip;
        if (adBean == null || status == null) {
            _log.debug("null info");
            return false;
        }
        if (status.isPredicted()) {
            if (adBean.getPredictedArrivalTime() > 0L && adBean.getPredictedArrivalTime() < this.getTime() && adBean.getDistanceFromStop() != 0.0) {
                _log.debug(" prediction in past drop");
                return false;
            }
            if (this.isOnDetour(status).booleanValue()) {
                _log.debug(" detour drop");
                return false;
            }
        } else if (adBean.getScheduledArrivalTime() > 0L && adBean.getScheduledArrivalTime() < this.getTime()) {
            _log.debug("scheduled arrival in past drop");
            return false;
        }
        String phase = status.getPhase();
        TripBean activeTrip = status.getActiveTrip();
        TripBean adTripBean = adBean.getTrip();
        if (!adTripBean.getId().equals(activeTrip.getId()) && adBean.getBlockTripSequence() - 1 != status.getBlockTripSequence() && adBean.getBlockTripSequence() + 1 != status.getBlockTripSequence()) {
            _log.debug("  " + status.getVehicleId() + " filtered out due to trip block sequence");
            return false;
        }
        if (activeTrip != null && !adTripBean.getId().equals(activeTrip.getId())) {
            distanceAlongTrip = status.getDistanceAlongTrip();
            totalDistanceAlongTrip = status.getTotalDistanceAlongTrip();
            double distanceFromTerminalMeters = totalDistanceAlongTrip - distanceAlongTrip;
            if (distanceFromTerminalMeters > (double)(this._previousTripFilterDistanceMiles * 1609.0f)) {
                _log.debug("  " + status.getVehicleId() + " filtered out due to distance from terminal on prev. trip " + distanceFromTerminalMeters + " > " + this._previousTripFilterDistanceMiles * 1609.0f);
                return false;
            }
        }
        if (phase != null && (phase.toUpperCase().equals("LAYOVER_BEFORE") || phase.toUpperCase().equals("LAYOVER_DURING"))) {
            distanceAlongTrip = status.getDistanceAlongTrip();
            totalDistanceAlongTrip = status.getTotalDistanceAlongTrip();
            ratio = distanceAlongTrip / totalDistanceAlongTrip;
            if (activeTrip != null && !adTripBean.getId().equals(activeTrip.getId()) && ratio < 0.5) {
                _log.debug("  " + status.getVehicleId() + " filtered out due to beginning of previous trip");
                return false;
            }
        }
        if (phase != null && (phase.toUpperCase().equals("LAYOVER_BEFORE") || phase.toUpperCase().equals("LAYOVER_DURING"))) {
            distanceAlongTrip = status.getDistanceAlongTrip();
            totalDistanceAlongTrip = status.getTotalDistanceAlongTrip();
            ratio = distanceAlongTrip / totalDistanceAlongTrip;
            if (!(activeTrip == null || adTripBean.getId().equals(activeTrip.getId()) || adBean.getBlockTripSequence() - 1 == status.getBlockTripSequence() && ratio > 0.5)) {
                _log.debug("  " + status.getVehicleId() + " filtered out due to at terminal/ratio");
                return false;
            }
        }
        _log.debug("include ad passed for " + status.getVehicleId());
        return true;
    }
}

