/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.realtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.presentation.services.realtime.PresentationService;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.BlockStopTimeBean;
import org.onebusaway.transit_data.model.blocks.BlockTripBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.siri.SiriDistanceExtension;
import org.onebusaway.transit_data_federation.siri.SiriExtensionWrapper;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.BlockRefStructure;
import uk.org.siri.siri.DataFrameRefStructure;
import uk.org.siri.siri.DestinationRefStructure;
import uk.org.siri.siri.DirectionRefStructure;
import uk.org.siri.siri.ExtensionsStructure;
import uk.org.siri.siri.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri.JourneyPatternRefStructure;
import uk.org.siri.siri.JourneyPlaceRefStructure;
import uk.org.siri.siri.LineRefStructure;
import uk.org.siri.siri.LocationStructure;
import uk.org.siri.siri.MonitoredCallStructure;
import uk.org.siri.siri.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri.NaturalLanguageStringStructure;
import uk.org.siri.siri.OccupancyEnumeration;
import uk.org.siri.siri.OnwardCallStructure;
import uk.org.siri.siri.OnwardCallsStructure;
import uk.org.siri.siri.OperatorRefStructure;
import uk.org.siri.siri.ProgressRateEnumeration;
import uk.org.siri.siri.SituationRefStructure;
import uk.org.siri.siri.SituationSimpleRefStructure;
import uk.org.siri.siri.StopPointRefStructure;
import uk.org.siri.siri.VehicleModesEnumeration;
import uk.org.siri.siri.VehicleRefStructure;

public final class SiriSupport {
    private static Logger _log = LoggerFactory.getLogger(SiriSupport.class);

    public static void fillMonitoredVehicleJourney(MonitoredVehicleJourneyStructure monitoredVehicleJourney, TripBean framedJourneyTripBean, ArrivalAndDepartureBean adBean, TripStatusBean currentVehicleTripStatus, StopBean monitoredCallStopBean, OnwardCallsMode onwardCallsMode, PresentationService presentationService, TransitDataService transitDataService, int maximumOnwardCalls, List<TimepointPredictionRecord> stopLevelPredictionsAcrossBlock, boolean hasRealtimeData, long responseTimestamp, boolean showRawLocation, boolean showApc) {
        if (currentVehicleTripStatus != null && "CANCELED".equals(currentVehicleTripStatus.getStatus())) {
            _log.error("aborting fillMVJ as trip is canceled");
            return;
        }
        BlockInstanceBean blockInstance = null;
        if (adBean == null) {
            blockInstance = transitDataService.getBlockInstance(currentVehicleTripStatus.getActiveTrip().getBlockId(), currentVehicleTripStatus.getServiceDate());
            if (blockInstance == null) {
                _log.error("illegal blockId {}", (Object)currentVehicleTripStatus.getActiveTrip().getBlockId());
                return;
            }
        } else {
            blockInstance = transitDataService.getBlockInstance(adBean.getTrip().getBlockId(), currentVehicleTripStatus.getServiceDate());
            if (blockInstance == null) {
                _log.error("illegal blockId {}", (Object)adBean.getTrip().getBlockId());
                return;
            }
        }
        List blockTrips = blockInstance.getBlockConfiguration().getTrips();
        if (monitoredCallStopBean == null) {
            monitoredCallStopBean = adBean == null ? currentVehicleTripStatus.getNextStop() : adBean.getStop();
        }
        LineRefStructure lineRef = new LineRefStructure();
        lineRef.setValue(framedJourneyTripBean.getRoute().getId());
        monitoredVehicleJourney.setLineRef(lineRef);
        OperatorRefStructure operatorRef = new OperatorRefStructure();
        operatorRef.setValue(framedJourneyTripBean.getRoute().getId().split("_")[0]);
        monitoredVehicleJourney.setOperatorRef(operatorRef);
        DirectionRefStructure directionRef = new DirectionRefStructure();
        directionRef.setValue(framedJourneyTripBean.getDirectionId());
        monitoredVehicleJourney.setDirectionRef(directionRef);
        NaturalLanguageStringStructure routeShortName = new NaturalLanguageStringStructure();
        String shortName = framedJourneyTripBean.getRoute().getShortName();
        if (shortName == null) {
            shortName = framedJourneyTripBean.getRoute().getId().split("_")[1];
        }
        String routeName = currentVehicleTripStatus.getActiveTrip().getRouteShortName();
        if (adBean != null) {
            routeName = adBean.getRouteShortName();
        }
        if (!StringUtils.isBlank((String)routeName)) {
            routeShortName.setValue(routeName);
        } else {
            routeShortName.setValue(shortName);
        }
        monitoredVehicleJourney.setPublishedLineName(routeShortName);
        JourneyPatternRefStructure journeyPattern = new JourneyPatternRefStructure();
        journeyPattern.setValue(framedJourneyTripBean.getShapeId());
        monitoredVehicleJourney.setJourneyPatternRef(journeyPattern);
        NaturalLanguageStringStructure headsign = new NaturalLanguageStringStructure();
        headsign.setValue(framedJourneyTripBean.getTripHeadsign());
        monitoredVehicleJourney.setDestinationName(headsign);
        VehicleRefStructure vehicleRef = new VehicleRefStructure();
        String vehicleAgencyAndId = currentVehicleTripStatus.getVehicleId();
        if (adBean != null) {
            vehicleAgencyAndId = adBean.getVehicleId();
        }
        if (vehicleAgencyAndId == null) {
            String tripId = framedJourneyTripBean.getId();
            String blockId = framedJourneyTripBean.getBlockId();
            String directionId = framedJourneyTripBean.getDirectionId();
            String vehicleIdHash = Integer.toString((tripId + blockId + directionId).hashCode());
            String agencyName = tripId.split("_")[0];
            String vehicleId = agencyName + "_" + vehicleIdHash;
            vehicleRef.setValue(vehicleId);
        } else {
            vehicleRef.setValue(vehicleAgencyAndId);
        }
        monitoredVehicleJourney.setVehicleRef(vehicleRef);
        monitoredVehicleJourney.getVehicleMode().add(SiriSupport.toVehicleMode(currentVehicleTripStatus.getVehicleType()));
        boolean isPredicted = currentVehicleTripStatus.isPredicted();
        if (adBean != null) {
            isPredicted = adBean.isPredicted();
        }
        monitoredVehicleJourney.setMonitored(Boolean.valueOf(isPredicted));
        monitoredVehicleJourney.setBearing(Float.valueOf((float)currentVehicleTripStatus.getOrientation()));
        monitoredVehicleJourney.setProgressRate(SiriSupport.getProgressRateForPhaseAndStatus(currentVehicleTripStatus.getStatus(), currentVehicleTripStatus.getPhase()));
        for (int i = 0; i < blockTrips.size(); ++i) {
            BlockTripBean blockTrip = (BlockTripBean)blockTrips.get(i);
            if (!blockTrip.getTrip().getId().equals(framedJourneyTripBean.getId())) continue;
            List stops = blockTrip.getBlockStopTimes();
            JourneyPlaceRefStructure origin = new JourneyPlaceRefStructure();
            origin.setValue(((BlockStopTimeBean)stops.get(0)).getStopTime().getStop().getId());
            monitoredVehicleJourney.setOriginRef(origin);
            StopBean lastStop = ((BlockStopTimeBean)stops.get(stops.size() - 1)).getStopTime().getStop();
            DestinationRefStructure dest = new DestinationRefStructure();
            dest.setValue(lastStop.getId());
            monitoredVehicleJourney.setDestinationRef(dest);
            break;
        }
        FramedVehicleJourneyRefStructure framedJourney = new FramedVehicleJourneyRefStructure();
        DataFrameRefStructure dataFrame = new DataFrameRefStructure();
        dataFrame.setValue(String.format("%1$tY-%1$tm-%1$td", currentVehicleTripStatus.getServiceDate()));
        framedJourney.setDataFrameRef(dataFrame);
        framedJourney.setDatedVehicleJourneyRef(framedJourneyTripBean.getId());
        monitoredVehicleJourney.setFramedVehicleJourneyRef(framedJourney);
        LocationStructure location = new LocationStructure();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(6);
        if (showRawLocation && currentVehicleTripStatus.getLastKnownLocation() != null || presentationService.isOnDetour(currentVehicleTripStatus).booleanValue()) {
            location.setLatitude(new BigDecimal(df.format(currentVehicleTripStatus.getLastKnownLocation().getLat())));
            location.setLongitude(new BigDecimal(df.format(currentVehicleTripStatus.getLastKnownLocation().getLon())));
        } else if (currentVehicleTripStatus.getLocation() != null) {
            location.setLatitude(new BigDecimal(df.format(currentVehicleTripStatus.getLocation().getLat())));
            location.setLongitude(new BigDecimal(df.format(currentVehicleTripStatus.getLocation().getLon())));
        }
        monitoredVehicleJourney.setVehicleLocation(location);
        ArrayList<String> progressStatuses = new ArrayList<String>();
        if (presentationService.isInLayover(currentVehicleTripStatus).booleanValue()) {
            progressStatuses.add("layover");
        }
        if (adBean != null && !adBean.getTrip().getId().equals(currentVehicleTripStatus.getActiveTrip().getId())) {
            progressStatuses.add("prevTrip");
        } else if (!framedJourneyTripBean.getId().equals(currentVehicleTripStatus.getActiveTrip().getId())) {
            progressStatuses.add("prevTrip");
        }
        if (!progressStatuses.isEmpty()) {
            NaturalLanguageStringStructure progressStatus = new NaturalLanguageStringStructure();
            progressStatus.setValue(StringUtils.join(progressStatuses, (String)","));
            monitoredVehicleJourney.setProgressStatus(progressStatus);
        }
        BlockRefStructure blockRef = new BlockRefStructure();
        blockRef.setValue(framedJourneyTripBean.getBlockId());
        monitoredVehicleJourney.setBlockRef(blockRef);
        HashMap<String, TimepointPredictionRecord> tripStopIdToPredictionRecordMap = new HashMap<String, TimepointPredictionRecord>();
        if (stopLevelPredictionsAcrossBlock != null) {
            for (TimepointPredictionRecord tpr : stopLevelPredictionsAcrossBlock) {
                if (tpr.isSkipped() || framedJourneyTripBean.getId() == null || !framedJourneyTripBean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)tpr.getTripId()))) continue;
                tripStopIdToPredictionRecordMap.put(tpr.getTripId() + ":" + AgencyAndId.convertToString((AgencyAndId)tpr.getTimepointId()), tpr);
            }
        }
        if (showApc) {
            if (adBean == null) {
                SiriSupport.fillOccupancy(monitoredVehicleJourney, transitDataService, currentVehicleTripStatus);
            } else {
                SiriSupport.fillOccupancy(monitoredVehicleJourney, transitDataService, adBean.getTripStatus());
            }
        }
        if (adBean == null) {
            SiriSupport.fillMonitoredCall(monitoredVehicleJourney, blockInstance, currentVehicleTripStatus, monitoredCallStopBean, presentationService, transitDataService, tripStopIdToPredictionRecordMap, hasRealtimeData, currentVehicleTripStatus.getActiveTrip().getId(), -1L, -1L, responseTimestamp);
            SiriSupport.fillOnwardCalls(monitoredVehicleJourney, blockInstance, framedJourneyTripBean, currentVehicleTripStatus, onwardCallsMode, presentationService, transitDataService, tripStopIdToPredictionRecordMap, maximumOnwardCalls, hasRealtimeData, responseTimestamp);
            SiriSupport.fillSituations(monitoredVehicleJourney, currentVehicleTripStatus);
        } else {
            SiriSupport.fillMonitoredCall(monitoredVehicleJourney, blockInstance, adBean.getTripStatus(), monitoredCallStopBean, presentationService, transitDataService, tripStopIdToPredictionRecordMap, hasRealtimeData, adBean.getTrip().getId(), adBean.getScheduledArrivalTime(), adBean.getScheduledDepartureTime(), responseTimestamp);
            SiriSupport.fillOnwardCalls(monitoredVehicleJourney, blockInstance, framedJourneyTripBean, adBean.getTripStatus(), onwardCallsMode, presentationService, transitDataService, tripStopIdToPredictionRecordMap, maximumOnwardCalls, hasRealtimeData, responseTimestamp);
            SiriSupport.fillSituations(monitoredVehicleJourney, adBean.getTripStatus());
        }
    }

    private static void fillOccupancy(MonitoredVehicleJourneyStructure mvj, TransitDataService tds, TripStatusBean tripStatus) {
        if (tripStatus == null || tripStatus.getActiveTrip() == null || tripStatus.getActiveTrip().getRoute() == null || tripStatus.getVehicleId() == null) {
            return;
        }
        VehicleOccupancyRecord vor = tds.getVehicleOccupancyRecordForVehicleIdAndRoute(AgencyAndId.convertFromString((String)tripStatus.getVehicleId()), tripStatus.getActiveTrip().getRoute().getId(), tripStatus.getActiveTrip().getDirectionId());
        mvj.setOccupancy(SiriSupport.mapOccupancyStatusToEnumeration(vor));
    }

    private static OccupancyEnumeration mapOccupancyStatusToEnumeration(VehicleOccupancyRecord vor) {
        if (vor == null || vor.getOccupancyStatus() == null) {
            return null;
        }
        switch (vor.getOccupancyStatus()) {
            case UNKNOWN: {
                return null;
            }
            case EMPTY: 
            case MANY_SEATS_AVAILABLE: {
                return OccupancyEnumeration.SEATS_AVAILABLE;
            }
            case FEW_SEATS_AVAILABLE: 
            case STANDING_ROOM_ONLY: {
                return OccupancyEnumeration.STANDING_AVAILABLE;
            }
            case FULL: 
            case CRUSHED_STANDING_ROOM_ONLY: 
            case NOT_ACCEPTING_PASSENGERS: {
                return OccupancyEnumeration.FULL;
            }
        }
        return null;
    }

    public static String mapSiriEnumToOccupancyStatus(String siriEnum) {
        if (siriEnum == null) {
            return null;
        }
        if (OccupancyEnumeration.SEATS_AVAILABLE.name().equals(siriEnum)) {
            return OccupancyStatus.MANY_SEATS_AVAILABLE.name();
        }
        if (OccupancyEnumeration.STANDING_AVAILABLE.name().equals(siriEnum)) {
            return OccupancyStatus.FEW_SEATS_AVAILABLE.name();
        }
        if (OccupancyEnumeration.FULL.name().equals(siriEnum)) {
            return OccupancyStatus.FULL.name();
        }
        return OccupancyStatus.UNKNOWN.name();
    }

    public static VehicleModesEnumeration toVehicleMode(String typeString) {
        VehicleModesEnumeration mode;
        if (typeString == null) {
            VehicleModesEnumeration mode2 = VehicleModesEnumeration.BUS;
            return mode2;
        }
        switch (typeString) {
            case "bus": {
                mode = VehicleModesEnumeration.BUS;
                break;
            }
            case "light_rail": {
                mode = VehicleModesEnumeration.TRAM;
                break;
            }
            case "rail": {
                mode = VehicleModesEnumeration.RAIL;
                break;
            }
            case "ferry": {
                mode = VehicleModesEnumeration.FERRY;
                break;
            }
            case "subway": {
                mode = VehicleModesEnumeration.TRAM;
                break;
            }
            default: {
                _log.error("Unknown vehicleMode " + typeString + ", defaulting to BUS");
                mode = VehicleModesEnumeration.BUS;
            }
        }
        return mode;
    }

    private static void fillOnwardCalls(MonitoredVehicleJourneyStructure monitoredVehicleJourney, BlockInstanceBean blockInstance, TripBean framedJourneyTripBean, TripStatusBean currentVehicleTripStatus, OnwardCallsMode onwardCallsMode, PresentationService presentationService, TransitDataService transitDataService, Map<String, TimepointPredictionRecord> stopLevelPredictions, int maximumOnwardCalls, boolean hasRealtimeData, long responseTimestamp) {
        String tripIdOfMonitoredCall = framedJourneyTripBean.getId();
        monitoredVehicleJourney.setOnwardCalls(new OnwardCallsStructure());
        if (maximumOnwardCalls == 0) {
            return;
        }
        List blockTrips = blockInstance.getBlockConfiguration().getTrips();
        double distanceOfVehicleAlongBlock = 0.0;
        int blockTripStopsAfterTheVehicle = 0;
        int onwardCallsAdded = 0;
        boolean foundActiveTrip = false;
        for (int i = 0; i < blockTrips.size(); ++i) {
            BlockTripBean blockTrip = (BlockTripBean)blockTrips.get(i);
            if (!foundActiveTrip) {
                if (currentVehicleTripStatus.getActiveTrip().getId().equals(blockTrip.getTrip().getId())) {
                    distanceOfVehicleAlongBlock += currentVehicleTripStatus.getDistanceAlongTrip();
                    foundActiveTrip = true;
                } else {
                    if (i + 1 >= blockTrips.size()) continue;
                    distanceOfVehicleAlongBlock = ((BlockTripBean)blockTrips.get(i + 1)).getDistanceAlongBlock();
                    continue;
                }
            }
            if (onwardCallsMode == OnwardCallsMode.STOP_MONITORING && !blockTrip.getTrip().getId().equals(tripIdOfMonitoredCall)) continue;
            boolean foundMatch = false;
            HashMap<String, Integer> visitNumberForStopMap = new HashMap<String, Integer>();
            for (BlockStopTimeBean stopTime : blockTrip.getBlockStopTimes()) {
                int visitNumber = SiriSupport.getVisitNumber(visitNumberForStopMap, stopTime.getStopTime().getStop());
                StopBean stop = stopTime.getStopTime().getStop();
                double distanceOfCallAlongTrip = stopTime.getDistanceAlongBlock() - blockTrip.getDistanceAlongBlock();
                double distanceOfVehicleFromCall = stopTime.getDistanceAlongBlock() - distanceOfVehicleAlongBlock;
                if (currentVehicleTripStatus.getActiveTrip().getId().equals(blockTrip.getTrip().getId())) {
                    if (!hasRealtimeData) {
                        if (stop.getId().equals(currentVehicleTripStatus.getNextStop().getId())) {
                            foundMatch = true;
                        }
                        if (!foundMatch) continue;
                        ++blockTripStopsAfterTheVehicle;
                        ArrivalsAndDeparturesQueryBean query = new ArrivalsAndDeparturesQueryBean();
                        StopWithArrivalsAndDeparturesBean result = transitDataService.getStopWithArrivalsAndDepartures(stop.getId(), query, new AgencyServiceInterval(SystemTime.currentTimeMillis()));
                        Collections.sort(result.getArrivalsAndDepartures(), new SortByTime());
                        if (result.getArrivalsAndDepartures().isEmpty()) continue;
                        ArrivalAndDepartureBean arrivalAndDeparture = (ArrivalAndDepartureBean)result.getArrivalsAndDepartures().get(0);
                        distanceOfVehicleFromCall = arrivalAndDeparture.getDistanceFromStop();
                    } else {
                        if (!(stopTime.getDistanceAlongBlock() >= distanceOfVehicleAlongBlock)) continue;
                        ++blockTripStopsAfterTheVehicle;
                    }
                } else {
                    ++blockTripStopsAfterTheVehicle;
                }
                OnwardCallStructure ocs = SiriSupport.getOnwardCallStructure(stop, presentationService, distanceOfCallAlongTrip, distanceOfVehicleFromCall, visitNumber, blockTripStopsAfterTheVehicle - 1, stopLevelPredictions.get(stopTime.getStopTime().getStop().getId()), hasRealtimeData, responseTimestamp, SiriSupport.getScheduledArrivalTime(currentVehicleTripStatus.getServiceDate(), -1L, stopTime), SiriSupport.getScheduledDepartureTime(currentVehicleTripStatus.getServiceDate(), -1L, stopTime), currentVehicleTripStatus.getScheduleDeviation());
                if (ocs != null) {
                    monitoredVehicleJourney.getOnwardCalls().getOnwardCall().add(ocs);
                }
                if (++onwardCallsAdded < maximumOnwardCalls) continue;
                return;
            }
            return;
        }
    }

    private static void fillMonitoredCall(MonitoredVehicleJourneyStructure monitoredVehicleJourney, BlockInstanceBean blockInstance, TripStatusBean tripStatus, StopBean monitoredCallStopBean, PresentationService presentationService, TransitDataService transitDataService, Map<String, TimepointPredictionRecord> tripStopLevelPredictions, boolean hasRealtimeData, String referenceTripId, long scheduledArrivalTime, long scheduledDepartureTime, long responseTimestamp) {
        List blockTrips = blockInstance.getBlockConfiguration().getTrips();
        double distanceOfVehicleAlongBlock = 0.0;
        int blockTripStopsAfterTheVehicle = 0;
        boolean foundActiveTrip = false;
        for (int i = 0; i < blockTrips.size(); ++i) {
            BlockTripBean blockTrip = (BlockTripBean)blockTrips.get(i);
            if (!foundActiveTrip) {
                if (referenceTripId.equals(blockTrip.getTrip().getId())) {
                    double distanceAlongTrip = tripStatus.getDistanceAlongTrip();
                    if (!hasRealtimeData) {
                        distanceAlongTrip = tripStatus.getScheduledDistanceAlongTrip();
                    }
                    distanceOfVehicleAlongBlock += distanceAlongTrip;
                    foundActiveTrip = true;
                } else {
                    if (i + 1 >= blockTrips.size()) continue;
                    distanceOfVehicleAlongBlock = ((BlockTripBean)blockTrips.get(i + 1)).getDistanceAlongBlock();
                    continue;
                }
            }
            HashMap<String, Integer> visitNumberForStopMap = new HashMap<String, Integer>();
            for (BlockStopTimeBean stopTime : blockTrip.getBlockStopTimes()) {
                MonitoredCallStructure msc;
                int visitNumber = SiriSupport.getVisitNumber(visitNumberForStopMap, stopTime.getStopTime().getStop());
                if (referenceTripId.equals(blockTrip.getTrip().getId())) {
                    if (stopTime.getDistanceAlongBlock() >= distanceOfVehicleAlongBlock) {
                        ++blockTripStopsAfterTheVehicle;
                    }
                } else {
                    ++blockTripStopsAfterTheVehicle;
                }
                if (!stopTime.getStopTime().getStop().getId().equals(monitoredCallStopBean.getId())) continue;
                if (!presentationService.isOnDetour(tripStatus).booleanValue() && (msc = SiriSupport.getMonitoredCallStructure(stopTime.getStopTime().getStop(), presentationService, stopTime.getDistanceAlongBlock() - blockTrip.getDistanceAlongBlock(), stopTime.getDistanceAlongBlock() - distanceOfVehicleAlongBlock, visitNumber, blockTripStopsAfterTheVehicle - 1, tripStopLevelPredictions.get(referenceTripId + ":" + monitoredCallStopBean.getId()), hasRealtimeData, responseTimestamp, SiriSupport.getScheduledArrivalTime(tripStatus.getServiceDate(), scheduledArrivalTime, stopTime), SiriSupport.getScheduledDepartureTime(tripStatus.getServiceDate(), scheduledDepartureTime, stopTime), tripStatus.getScheduleDeviation())) != null) {
                    monitoredVehicleJourney.setMonitoredCall(msc);
                }
                if (monitoredVehicleJourney.getMonitoredCall() == null) continue;
                return;
            }
        }
    }

    private static long getScheduledArrivalTime(long serviceDate, long scheduledArrivalTime, BlockStopTimeBean stopTime) {
        if (scheduledArrivalTime > 0L) {
            return scheduledArrivalTime;
        }
        return serviceDate + (long)(stopTime.getStopTime().getArrivalTime() * 1000);
    }

    private static long getScheduledDepartureTime(long serviceDate, long scheduledDepartureTime, BlockStopTimeBean stopTime) {
        if (scheduledDepartureTime > 0L) {
            return scheduledDepartureTime;
        }
        return serviceDate + (long)(stopTime.getStopTime().getDepartureTime() * 1000);
    }

    private static void fillSituations(MonitoredVehicleJourneyStructure monitoredVehicleJourney, TripStatusBean tripStatus) {
        if (tripStatus == null || tripStatus.getSituations() == null || tripStatus.getSituations().isEmpty()) {
            return;
        }
        List situationRef = monitoredVehicleJourney.getSituationRef();
        for (ServiceAlertBean situation : tripStatus.getSituations()) {
            SituationRefStructure sitRef = new SituationRefStructure();
            SituationSimpleRefStructure sitSimpleRef = new SituationSimpleRefStructure();
            sitSimpleRef.setValue(situation.getId());
            sitRef.setSituationSimpleRef(sitSimpleRef);
            situationRef.add(sitRef);
        }
    }

    private static OnwardCallStructure getOnwardCallStructure(StopBean stopBean, PresentationService presentationService, double distanceOfCallAlongTrip, double distanceOfVehicleFromCall, int visitNumber, int index, TimepointPredictionRecord prediction, boolean hasRealtimeData, long responseTimestamp, long scheduledArrivalTime, long scheduledDepartureTime, double scheduleDeviation) {
        Date expectedDepartureTime;
        boolean hasPrediction = prediction != null;
        Long predictedArrivalTime = null;
        Long predictedDepartureTime = null;
        if (hasPrediction) {
            predictedArrivalTime = prediction.getTimepointPredictedArrivalTime();
            predictedDepartureTime = prediction.getTimepointPredictedDepartureTime();
        }
        OnwardCallStructure onwardCallStructure = new OnwardCallStructure();
        onwardCallStructure.setVisitNumber(BigInteger.valueOf(visitNumber));
        StopPointRefStructure stopPointRef = new StopPointRefStructure();
        stopPointRef.setValue(stopBean.getId());
        onwardCallStructure.setStopPointRef(stopPointRef);
        if (stopBean.getCode() != null) {
            NaturalLanguageStringStructure platform = new NaturalLanguageStringStructure();
            platform.setValue(stopBean.getCode());
            onwardCallStructure.setArrivalPlatformName(platform);
        }
        NaturalLanguageStringStructure stopPoint = new NaturalLanguageStringStructure();
        stopPoint.setValue(stopBean.getName());
        onwardCallStructure.setStopPointName(stopPoint);
        if (prediction != null && prediction.getScheduleRelationship() != null && prediction.isSkipped()) {
            _log.info("SKIPPED STOP: " + stopBean.getId());
            return null;
        }
        Date expectedArrivalTime = SiriSupport.getExpectedTime(hasRealtimeData, hasPrediction, predictedArrivalTime, scheduledArrivalTime, scheduleDeviation, responseTimestamp);
        if (expectedArrivalTime.after(expectedDepartureTime = SiriSupport.getExpectedTime(hasRealtimeData, hasPrediction, predictedDepartureTime, scheduledDepartureTime, scheduleDeviation, responseTimestamp))) {
            expectedDepartureTime = expectedArrivalTime;
        }
        onwardCallStructure.setExpectedArrivalTime(expectedArrivalTime);
        onwardCallStructure.setExpectedDepartureTime(expectedDepartureTime);
        onwardCallStructure.setAimedArrivalTime(new Date(scheduledArrivalTime));
        SiriExtensionWrapper wrapper = new SiriExtensionWrapper();
        ExtensionsStructure distancesExtensions = new ExtensionsStructure();
        SiriDistanceExtension distances = new SiriDistanceExtension();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setGroupingUsed(false);
        distances.setStopsFromCall(Integer.valueOf(index));
        distances.setCallDistanceAlongRoute(Double.valueOf(NumberUtils.toDouble((String)df.format(distanceOfCallAlongTrip))));
        distances.setDistanceFromCall(Double.valueOf(NumberUtils.toDouble((String)df.format(distanceOfVehicleFromCall))));
        distances.setPresentableDistance(presentationService.getPresentableDistance(distances));
        wrapper.setDistances(distances);
        distancesExtensions.setAny((Object)wrapper);
        onwardCallStructure.setExtensions(distancesExtensions);
        return onwardCallStructure;
    }

    private static MonitoredCallStructure getMonitoredCallStructure(StopBean stopBean, PresentationService presentationService, double distanceOfCallAlongTrip, double distanceOfVehicleFromCall, int visitNumber, int index, TimepointPredictionRecord prediction, boolean hasRealtimeData, long responseTimestamp, long scheduledArrivalTime, long scheduledDepartureTime, double scheduleDeviation) {
        boolean hasPrediction = prediction != null;
        Long predictedArrivalTime = null;
        Long predictedDepartureTime = null;
        if (hasPrediction) {
            predictedArrivalTime = prediction.getTimepointPredictedArrivalTime();
            predictedDepartureTime = prediction.getTimepointPredictedDepartureTime();
        }
        if (prediction != null && prediction.getScheduleRelationship() != null && prediction.isSkipped()) {
            _log.info("SKIPPED STOP (MONITORED): " + stopBean.getId());
            return null;
        }
        MonitoredCallStructure monitoredCallStructure = new MonitoredCallStructure();
        monitoredCallStructure.setVisitNumber(BigInteger.valueOf(visitNumber));
        StopPointRefStructure stopPointRef = new StopPointRefStructure();
        stopPointRef.setValue(stopBean.getId());
        monitoredCallStructure.setStopPointRef(stopPointRef);
        NaturalLanguageStringStructure stopPoint = new NaturalLanguageStringStructure();
        stopPoint.setValue(stopBean.getName());
        monitoredCallStructure.setStopPointName(stopPoint);
        Date expectedArrivalTime = SiriSupport.getExpectedTime(hasRealtimeData, hasPrediction, predictedArrivalTime, scheduledArrivalTime, scheduleDeviation, responseTimestamp);
        Date expectedDepartureTime = SiriSupport.getExpectedTime(hasRealtimeData, hasPrediction, predictedDepartureTime, scheduledDepartureTime, scheduleDeviation, responseTimestamp);
        if (expectedArrivalTime.after(expectedDepartureTime)) {
            expectedDepartureTime = expectedArrivalTime;
        }
        monitoredCallStructure.setExpectedArrivalTime(expectedArrivalTime);
        monitoredCallStructure.setExpectedDepartureTime(expectedDepartureTime);
        if (monitoredCallStructure.getExpectedArrivalTime() != null) {
            monitoredCallStructure.setAimedArrivalTime(new Date(scheduledArrivalTime));
        }
        SiriExtensionWrapper wrapper = new SiriExtensionWrapper();
        ExtensionsStructure distancesExtensions = new ExtensionsStructure();
        SiriDistanceExtension distances = new SiriDistanceExtension();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setGroupingUsed(false);
        distances.setStopsFromCall(Integer.valueOf(index));
        distances.setCallDistanceAlongRoute(Double.valueOf(NumberUtils.toDouble((String)df.format(distanceOfCallAlongTrip))));
        distances.setDistanceFromCall(Double.valueOf(NumberUtils.toDouble((String)df.format(distanceOfVehicleFromCall))));
        distances.setPresentableDistance(presentationService.getPresentableDistance(distances));
        long deviation = 0L;
        if (monitoredCallStructure.getExpectedArrivalTime() != null && monitoredCallStructure.getAimedArrivalTime() != null) {
            long deviationSeconds = monitoredCallStructure.getExpectedArrivalTime().getTime() - monitoredCallStructure.getAimedArrivalTime().getTime();
            deviation = Math.round((double)deviationSeconds / 60000.0);
        }
        wrapper.setDeviation(String.valueOf(deviation));
        wrapper.setDistances(distances);
        distancesExtensions.setAny((Object)wrapper);
        monitoredCallStructure.setExtensions(distancesExtensions);
        return monitoredCallStructure;
    }

    private static Date getExpectedTime(boolean hasRealtimeData, boolean hasPrediction, Long predictedTime, long scheduledTime, double scheduleDeviation, long responseTimestamp) {
        if (hasRealtimeData) {
            if (!hasPrediction || predictedTime < responseTimestamp) {
                long timeWithDeviation = scheduledTime + (long)scheduleDeviation * 1000L;
                if (timeWithDeviation < responseTimestamp) {
                    return new Date(responseTimestamp + 1000L);
                }
                return new Date(timeWithDeviation);
            }
            return new Date(predictedTime);
        }
        return new Date(scheduledTime);
    }

    private static int getVisitNumber(HashMap<String, Integer> visitNumberForStop, StopBean stop) {
        int visitNumber = visitNumberForStop.containsKey(stop.getId()) ? visitNumberForStop.get(stop.getId()) + 1 : 1;
        visitNumberForStop.put(stop.getId(), visitNumber);
        return visitNumber;
    }

    private static ProgressRateEnumeration getProgressRateForPhaseAndStatus(String status, String phase) {
        if (phase == null) {
            return ProgressRateEnumeration.UNKNOWN;
        }
        if (phase.toLowerCase().startsWith("layover") || phase.toLowerCase().startsWith("deadhead") || phase.toLowerCase().equals("at_base")) {
            return ProgressRateEnumeration.NO_PROGRESS;
        }
        if (status != null && status.toLowerCase().equals("stalled")) {
            return ProgressRateEnumeration.NO_PROGRESS;
        }
        if (phase.toLowerCase().equals("in_progress")) {
            return ProgressRateEnumeration.NORMAL_PROGRESS;
        }
        return ProgressRateEnumeration.UNKNOWN;
    }

    public static class SortByTime
    implements Comparator<ArrivalAndDepartureBean> {
        @Override
        public int compare(ArrivalAndDepartureBean o1, ArrivalAndDepartureBean o2) {
            long b;
            long a = o1.computeBestDepartureTime();
            return a == (b = o2.computeBestDepartureTime()) ? 0 : (a < b ? -1 : 1);
        }
    }

    public static enum OnwardCallsMode {
        VEHICLE_MONITORING,
        STOP_MONITORING;

    }
}

